/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.FacetUtils;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.FloatTaxonomyFacets;
import org.apache.lucene.facet.taxonomy.OrdinalsReader;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.util.IntsRef;

public class TaxonomyFacetSumValueSource
extends FloatTaxonomyFacets {
    private final OrdinalsReader ordinalsReader;

    public TaxonomyFacetSumValueSource(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, DoubleValuesSource valueSource) throws IOException {
        this("$facets", taxoReader, config, fc, valueSource);
    }

    public TaxonomyFacetSumValueSource(String indexField, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, DoubleValuesSource valueSource) throws IOException {
        super(indexField, taxoReader, config);
        this.ordinalsReader = null;
        this.sumValues(fc.getMatchingDocs(), fc.getKeepScores(), valueSource);
    }

    @Deprecated
    public TaxonomyFacetSumValueSource(OrdinalsReader ordinalsReader, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, DoubleValuesSource vs) throws IOException {
        super(ordinalsReader.getIndexFieldName(), taxoReader, config);
        this.ordinalsReader = ordinalsReader;
        this.sumValues(fc.getMatchingDocs(), fc.getKeepScores(), vs);
    }

    private static DoubleValues scores(final FacetsCollector.MatchingDocs hits) {
        return new DoubleValues(){
            int index = -1;

            public double doubleValue() throws IOException {
                return hits.scores[this.index];
            }

            public boolean advanceExact(int doc) throws IOException {
                ++this.index;
                return true;
            }
        };
    }

    private void sumValues(List<FacetsCollector.MatchingDocs> matchingDocs, boolean keepScores, DoubleValuesSource valueSource) throws IOException {
        if (this.ordinalsReader != null) {
            IntsRef scratch = new IntsRef();
            for (FacetsCollector.MatchingDocs hits : matchingDocs) {
                int doc;
                OrdinalsReader.OrdinalsSegmentReader ords = this.ordinalsReader.getReader(hits.context);
                DoubleValues scores = keepScores ? TaxonomyFacetSumValueSource.scores(hits) : null;
                DoubleValues functionValues = valueSource.getValues(hits.context, scores);
                DocIdSetIterator docs = hits.bits.iterator();
                while ((doc = docs.nextDoc()) != Integer.MAX_VALUE) {
                    ords.get(doc, scratch);
                    if (!functionValues.advanceExact(doc)) continue;
                    float value = (float)functionValues.doubleValue();
                    for (int i = 0; i < scratch.length; ++i) {
                        int n = scratch.ints[i];
                        this.values[n] = this.values[n] + value;
                    }
                }
            }
        } else {
            for (FacetsCollector.MatchingDocs hits : matchingDocs) {
                SortedNumericDocValues ordinalValues = FacetUtils.loadOrdinalValues(hits.context.reader(), this.indexFieldName);
                if (ordinalValues == null) continue;
                DoubleValues scores = keepScores ? TaxonomyFacetSumValueSource.scores(hits) : null;
                DoubleValues functionValues = valueSource.getValues(hits.context, scores);
                DocIdSetIterator it = ConjunctionUtils.intersectIterators(List.of(hits.bits.iterator(), ordinalValues));
                int doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (functionValues.advanceExact(doc)) {
                        float value = (float)functionValues.doubleValue();
                        int ordinalCount = ordinalValues.docValueCount();
                        for (int i = 0; i < ordinalCount; ++i) {
                            int n = (int)ordinalValues.nextValue();
                            this.values[n] = this.values[n] + value;
                        }
                    }
                    doc = it.nextDoc();
                }
            }
        }
        this.rollup();
    }
}

