/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.FloatTaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;

public class TaxonomyFacetSumFloatAssociations
extends FloatTaxonomyFacets {
    public TaxonomyFacetSumFloatAssociations(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        this("$facets", taxoReader, config, fc);
    }

    public TaxonomyFacetSumFloatAssociations(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.sumValues(fc.getMatchingDocs());
    }

    private final void sumValues(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            int doc;
            BinaryDocValues dv = hits.context.reader().getBinaryDocValues(this.indexFieldName);
            if (dv == null) continue;
            DocIdSetIterator docs = hits.bits.iterator();
            while ((doc = docs.nextDoc()) != Integer.MAX_VALUE) {
                if (dv.docID() < doc) {
                    dv.advance(doc);
                }
                if (dv.docID() != doc) continue;
                BytesRef bytesRef = dv.binaryValue();
                byte[] bytes = bytesRef.bytes;
                int end = bytesRef.offset + bytesRef.length;
                for (int offset = bytesRef.offset; offset < end; offset += 4) {
                    int ord = BitUtil.VH_BE_INT.get(bytes, offset);
                    float value = BitUtil.VH_BE_FLOAT.get(bytes, offset += 4);
                    int n = ord;
                    this.values[n] = this.values[n] + value;
                }
            }
        }
    }
}

