/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sortedset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetUtils;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndIntQueue;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;

public class ConcurrentSortedSetDocValuesFacetCounts
extends Facets {
    final ExecutorService exec;
    final SortedSetDocValuesReaderState state;
    final SortedSetDocValues dv;
    final String field;
    final AtomicIntegerArray counts;

    public ConcurrentSortedSetDocValuesFacetCounts(SortedSetDocValuesReaderState state, ExecutorService exec) throws IOException, InterruptedException {
        this(state, null, exec);
    }

    public ConcurrentSortedSetDocValuesFacetCounts(SortedSetDocValuesReaderState state, FacetsCollector hits, ExecutorService exec) throws IOException, InterruptedException {
        this.state = state;
        this.field = state.getField();
        this.exec = exec;
        this.dv = state.getDocValues();
        this.counts = new AtomicIntegerArray(state.getSize());
        if (hits == null) {
            this.countAll();
        } else {
            this.count(hits.getMatchingDocs());
        }
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        if (topN <= 0) {
            throw new IllegalArgumentException("topN must be > 0 (got: " + topN + ")");
        }
        if (path.length > 0) {
            throw new IllegalArgumentException("path should be 0 length");
        }
        SortedSetDocValuesReaderState.OrdRange ordRange = this.state.getOrdRange(dim);
        if (ordRange == null) {
            return null;
        }
        return this.getDim(dim, ordRange, topN);
    }

    private FacetResult getDim(String dim, SortedSetDocValuesReaderState.OrdRange ordRange, int topN) throws IOException {
        TopOrdAndIntQueue q = null;
        int bottomCount = 0;
        int dimCount = 0;
        int childCount = 0;
        TopOrdAndIntQueue.OrdAndValue reuse = null;
        for (int ord = ordRange.start; ord <= ordRange.end; ++ord) {
            if (this.counts.get(ord) <= 0) continue;
            dimCount += this.counts.get(ord);
            ++childCount;
            if (this.counts.get(ord) <= bottomCount) continue;
            if (reuse == null) {
                reuse = new TopOrdAndIntQueue.OrdAndValue();
            }
            reuse.ord = ord;
            reuse.value = this.counts.get(ord);
            if (q == null) {
                q = new TopOrdAndIntQueue(topN);
            }
            reuse = (TopOrdAndIntQueue.OrdAndValue)q.insertWithOverflow(reuse);
            if (q.size() != topN) continue;
            bottomCount = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
        }
        if (q == null) {
            return null;
        }
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndIntQueue.OrdAndValue ordAndValue = (TopOrdAndIntQueue.OrdAndValue)q.pop();
            BytesRef term = this.dv.lookupOrd((long)ordAndValue.ord);
            String[] parts = FacetsConfig.stringToPath(term.utf8ToString());
            labelValues[i] = new LabelAndValue(parts[1], ordAndValue.value);
        }
        return new FacetResult(dim, new String[0], dimCount, labelValues, childCount);
    }

    private void count(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException, InterruptedException {
        OrdinalMap ordinalMap = this.dv instanceof MultiDocValues.MultiSortedSetDocValues && matchingDocs.size() > 1 ? ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping : null;
        IndexReader reader = this.state.getReader();
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
        for (FacetsCollector.MatchingDocs matchingDocs2 : matchingDocs) {
            if (ReaderUtil.getTopLevelContext((IndexReaderContext)matchingDocs2.context).reader() != reader) {
                throw new IllegalStateException("the SortedSetDocValuesReaderState provided to this class does not match the reader being searched; you must create a new SortedSetDocValuesReaderState every time you open a new IndexReader");
            }
            results.add(this.exec.submit(new CountOneSegment(matchingDocs2.context.reader(), matchingDocs2, ordinalMap, matchingDocs2.context.ord)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                throw IOUtils.rethrowAlways((Throwable)(cause != null ? cause : ee));
            }
        }
    }

    private void countAll() throws IOException, InterruptedException {
        OrdinalMap ordinalMap = this.dv instanceof MultiDocValues.MultiSortedSetDocValues ? ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping : null;
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
        for (LeafReaderContext leafReaderContext : this.state.getReader().leaves()) {
            results.add(this.exec.submit(new CountOneSegment(leafReaderContext.reader(), null, ordinalMap, leafReaderContext.ord)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                throw IOUtils.rethrowAlways((Throwable)(cause != null ? cause : ee));
            }
        }
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        if (path.length != 1) {
            throw new IllegalArgumentException("path must be length=1");
        }
        int ord = (int)this.dv.lookupTerm(new BytesRef((CharSequence)FacetsConfig.pathToString(dim, path)));
        if (ord < 0) {
            return -1;
        }
        return this.counts.get(ord);
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        for (Map.Entry<String, SortedSetDocValuesReaderState.OrdRange> ent : this.state.getPrefixToOrdRange().entrySet()) {
            FacetResult fr = this.getDim(ent.getKey(), ent.getValue(), topN);
            if (fr == null) continue;
            results.add(fr);
        }
        Collections.sort(results, new Comparator<FacetResult>(){

            @Override
            public int compare(FacetResult a, FacetResult b) {
                if (a.value.intValue() > b.value.intValue()) {
                    return -1;
                }
                if (b.value.intValue() > a.value.intValue()) {
                    return 1;
                }
                return a.dim.compareTo(b.dim);
            }
        });
        return results;
    }

    private class CountOneSegment
    implements Callable<Void> {
        final LeafReader leafReader;
        final FacetsCollector.MatchingDocs hits;
        final OrdinalMap ordinalMap;
        final int segOrd;

        public CountOneSegment(LeafReader leafReader, FacetsCollector.MatchingDocs hits, OrdinalMap ordinalMap, int segOrd) {
            assert (leafReader != null);
            this.leafReader = leafReader;
            this.hits = hits;
            this.ordinalMap = ordinalMap;
            this.segOrd = segOrd;
        }

        @Override
        public Void call() throws IOException {
            Bits liveDocs;
            SortedDocValues valuesIt;
            SortedSetDocValues multiValues = DocValues.getSortedSet((LeafReader)this.leafReader, (String)ConcurrentSortedSetDocValuesFacetCounts.this.field);
            if (multiValues == null) {
                return null;
            }
            SortedDocValues singleValues = DocValues.unwrapSingleton((SortedSetDocValues)multiValues);
            Object object = valuesIt = singleValues != null ? singleValues : multiValues;
            Object it = this.hits == null ? ((liveDocs = this.leafReader.getLiveDocs()) != null ? FacetUtils.liveDocsDISI((DocIdSetIterator)valuesIt, liveDocs) : valuesIt) : ConjunctionUtils.intersectIterators(Arrays.asList(this.hits.bits.iterator(), valuesIt));
            if (this.ordinalMap != null) {
                LongValues ordMap = this.ordinalMap.getGlobalOrds(this.segOrd);
                int numSegOrds = (int)multiValues.getValueCount();
                if (this.hits != null && this.hits.totalHits < numSegOrds / 10) {
                    if (singleValues != null) {
                        int doc = it.nextDoc();
                        while (doc != Integer.MAX_VALUE) {
                            ConcurrentSortedSetDocValuesFacetCounts.this.counts.incrementAndGet((int)ordMap.get((long)singleValues.ordValue()));
                            doc = it.nextDoc();
                        }
                    } else {
                        int doc = it.nextDoc();
                        while (doc != Integer.MAX_VALUE) {
                            int term = (int)multiValues.nextOrd();
                            while ((long)term != -1L) {
                                ConcurrentSortedSetDocValuesFacetCounts.this.counts.incrementAndGet((int)ordMap.get((long)term));
                                term = (int)multiValues.nextOrd();
                            }
                            doc = it.nextDoc();
                        }
                    }
                } else {
                    int doc;
                    int[] segCounts = new int[numSegOrds];
                    if (singleValues != null) {
                        doc = it.nextDoc();
                        while (doc != Integer.MAX_VALUE) {
                            int n = singleValues.ordValue();
                            segCounts[n] = segCounts[n] + 1;
                            doc = it.nextDoc();
                        }
                    } else {
                        doc = it.nextDoc();
                        while (doc != Integer.MAX_VALUE) {
                            int term = (int)multiValues.nextOrd();
                            while ((long)term != -1L) {
                                int n = term;
                                segCounts[n] = segCounts[n] + 1;
                                term = (int)multiValues.nextOrd();
                            }
                            doc = it.nextDoc();
                        }
                    }
                    for (int ord = 0; ord < numSegOrds; ++ord) {
                        int count = segCounts[ord];
                        if (count == 0) continue;
                        ConcurrentSortedSetDocValuesFacetCounts.this.counts.addAndGet((int)ordMap.get((long)ord), count);
                    }
                }
            } else if (singleValues != null) {
                int doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    ConcurrentSortedSetDocValuesFacetCounts.this.counts.incrementAndGet(singleValues.ordValue());
                    doc = it.nextDoc();
                }
            } else {
                int doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    int term = (int)multiValues.nextOrd();
                    while ((long)term != -1L) {
                        ConcurrentSortedSetDocValuesFacetCounts.this.counts.incrementAndGet(term);
                        term = (int)multiValues.nextOrd();
                    }
                    doc = it.nextDoc();
                }
            }
            return null;
        }
    }
}

