/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetUtils;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.StringDocValuesReaderState;
import org.apache.lucene.facet.TopOrdAndIntQueue;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;

public class StringValueFacetCounts
extends Facets {
    private final IndexReader reader;
    private final String field;
    private final OrdinalMap ordinalMap;
    private final SortedSetDocValues docValues;
    private final int[] denseCounts;
    private final IntIntHashMap sparseCounts;
    private final int cardinality;
    private int totalDocCount;

    public StringValueFacetCounts(StringDocValuesReaderState state) throws IOException {
        this(state, null);
    }

    public StringValueFacetCounts(StringDocValuesReaderState state, FacetsCollector facetsCollector) throws IOException {
        this.reader = state.reader;
        this.field = state.field;
        this.ordinalMap = state.ordinalMap;
        this.docValues = this.getDocValues();
        long valueCount = this.docValues.getValueCount();
        if (valueCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("can only handle valueCount < Integer.MAX_VALUE; got " + valueCount);
        }
        this.cardinality = (int)valueCount;
        if (facetsCollector != null) {
            if (this.cardinality < 1024) {
                this.sparseCounts = null;
                this.denseCounts = new int[this.cardinality];
            } else {
                int totalHits = 0;
                int totalDocs = 0;
                for (FacetsCollector.MatchingDocs matchingDocs : facetsCollector.getMatchingDocs()) {
                    totalHits += matchingDocs.totalHits;
                    totalDocs += matchingDocs.context.reader().maxDoc();
                }
                if (totalHits < totalDocs / 10) {
                    this.sparseCounts = new IntIntHashMap();
                    this.denseCounts = null;
                } else {
                    this.sparseCounts = null;
                    this.denseCounts = new int[this.cardinality];
                }
            }
            this.count(facetsCollector);
        } else {
            this.sparseCounts = null;
            this.denseCounts = new int[this.cardinality];
            this.countAll();
        }
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        if (topN <= 0) {
            throw new IllegalArgumentException("topN must be > 0 (got: " + topN + ")");
        }
        if (!dim.equals(this.field)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path.length != 0) {
            throw new IllegalArgumentException("path.length should be 0");
        }
        topN = Math.min(topN, this.cardinality);
        TopOrdAndIntQueue q = null;
        TopOrdAndIntQueue.OrdAndValue reuse = null;
        int bottomCount = 0;
        int childCount = 0;
        if (this.sparseCounts != null) {
            for (IntIntCursor cursor : this.sparseCounts) {
                ++childCount;
                int count = cursor.value;
                if (count <= bottomCount) continue;
                if (reuse == null) {
                    reuse = new TopOrdAndIntQueue.OrdAndValue();
                }
                reuse.ord = cursor.key;
                reuse.value = count;
                if (q == null) {
                    q = new TopOrdAndIntQueue(topN);
                }
                reuse = (TopOrdAndIntQueue.OrdAndValue)q.insertWithOverflow(reuse);
                if (q.size() != topN) continue;
                bottomCount = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
            }
        } else {
            for (int i = 0; i < this.denseCounts.length; ++i) {
                int count = this.denseCounts[i];
                if (count == 0) continue;
                ++childCount;
                if (count <= bottomCount) continue;
                if (reuse == null) {
                    reuse = new TopOrdAndIntQueue.OrdAndValue();
                }
                reuse.ord = i;
                reuse.value = count;
                if (q == null) {
                    q = new TopOrdAndIntQueue(topN);
                }
                reuse = (TopOrdAndIntQueue.OrdAndValue)q.insertWithOverflow(reuse);
                if (q.size() != topN) continue;
                bottomCount = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
            }
        }
        int resultCount = q == null ? 0 : q.size();
        LabelAndValue[] labelValues = new LabelAndValue[resultCount];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndIntQueue.OrdAndValue ordAndValue = (TopOrdAndIntQueue.OrdAndValue)q.pop();
            BytesRef term = this.docValues.lookupOrd((long)ordAndValue.ord);
            labelValues[i] = new LabelAndValue(term.utf8ToString(), ordAndValue.value);
        }
        return new FacetResult(this.field, new String[0], this.totalDocCount, labelValues, childCount);
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        if (!dim.equals(this.field)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path.length != 1) {
            throw new IllegalArgumentException("path must be length=1");
        }
        int ord = (int)this.docValues.lookupTerm(new BytesRef((CharSequence)path[0]));
        if (ord < 0) {
            return -1;
        }
        return this.sparseCounts != null ? this.sparseCounts.get(ord) : this.denseCounts[ord];
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        return Collections.singletonList(this.getTopChildren(topN, this.field, new String[0]));
    }

    private SortedSetDocValues getDocValues() throws IOException {
        List leaves = this.reader.leaves();
        int leafCount = leaves.size();
        if (leafCount == 0) {
            return DocValues.emptySortedSet();
        }
        if (leafCount == 1) {
            return DocValues.getSortedSet((LeafReader)((LeafReaderContext)leaves.get(0)).reader(), (String)this.field);
        }
        SortedSetDocValues[] docValues = new SortedSetDocValues[leafCount];
        int[] starts = new int[leafCount + 1];
        long cost = 0L;
        for (int i = 0; i < leafCount; ++i) {
            SortedSetDocValues dv;
            LeafReaderContext context = (LeafReaderContext)leaves.get(i);
            docValues[i] = dv = DocValues.getSortedSet((LeafReader)context.reader(), (String)this.field);
            starts[i] = context.docBase;
            cost += dv.cost();
        }
        starts[leafCount] = this.reader.maxDoc();
        return new MultiDocValues.MultiSortedSetDocValues(docValues, starts, this.ordinalMap, cost);
    }

    private void count(FacetsCollector facetsCollector) throws IOException {
        List<FacetsCollector.MatchingDocs> matchingDocs = facetsCollector.getMatchingDocs();
        if (matchingDocs.isEmpty()) {
            return;
        }
        if (matchingDocs.size() == 1) {
            FacetsCollector.MatchingDocs hits = matchingDocs.get(0);
            this.validateState(hits.context);
            assert (this.ordinalMap == null);
            this.countOneSegment(this.docValues, hits.context.ord, hits, null);
        } else {
            this.validateState(matchingDocs.get((int)0).context);
            for (int i = 0; i < matchingDocs.size(); ++i) {
                FacetsCollector.MatchingDocs hits = matchingDocs.get(i);
                assert (this.ordinalMap != null);
                assert (this.docValues instanceof MultiDocValues.MultiSortedSetDocValues);
                MultiDocValues.MultiSortedSetDocValues multiValues = (MultiDocValues.MultiSortedSetDocValues)this.docValues;
                this.countOneSegment(multiValues.values[i], hits.context.ord, hits, null);
            }
        }
    }

    private void countAll() throws IOException {
        List leaves = this.reader.leaves();
        int numLeaves = leaves.size();
        if (numLeaves == 0) {
            return;
        }
        if (numLeaves == 1) {
            assert (this.ordinalMap == null);
            LeafReaderContext context = (LeafReaderContext)leaves.get(0);
            this.countOneSegment(this.docValues, context.ord, null, context.reader().getLiveDocs());
        } else {
            assert (this.ordinalMap != null);
            assert (this.docValues instanceof MultiDocValues.MultiSortedSetDocValues);
            MultiDocValues.MultiSortedSetDocValues multiValues = (MultiDocValues.MultiSortedSetDocValues)this.docValues;
            for (int i = 0; i < numLeaves; ++i) {
                LeafReaderContext context = (LeafReaderContext)leaves.get(i);
                this.countOneSegment(multiValues.values[i], context.ord, null, context.reader().getLiveDocs());
            }
        }
    }

    private void countOneSegment(SortedSetDocValues multiValues, int segmentOrd, FacetsCollector.MatchingDocs hits, Bits liveDocs) throws IOException {
        SortedDocValues valuesIt;
        SortedDocValues singleValues = DocValues.unwrapSingleton((SortedSetDocValues)multiValues);
        Object object = valuesIt = singleValues != null ? singleValues : multiValues;
        Object it = hits == null ? (liveDocs != null ? FacetUtils.liveDocsDISI((DocIdSetIterator)valuesIt, liveDocs) : valuesIt) : ConjunctionUtils.intersectIterators(Arrays.asList(hits.bits.iterator(), valuesIt));
        if (this.ordinalMap == null) {
            if (singleValues != null) {
                int doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    this.increment(singleValues.ordValue());
                    ++this.totalDocCount;
                    doc = it.nextDoc();
                }
            } else {
                int doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    int term = (int)multiValues.nextOrd();
                    boolean countedDocInTotal = false;
                    while ((long)term != -1L) {
                        this.increment(term);
                        if (!countedDocInTotal) {
                            ++this.totalDocCount;
                            countedDocInTotal = true;
                        }
                        term = (int)multiValues.nextOrd();
                    }
                    doc = it.nextDoc();
                }
            }
        } else {
            LongValues ordMap = this.ordinalMap.getGlobalOrds(segmentOrd);
            int segmentCardinality = (int)multiValues.getValueCount();
            if (hits != null && hits.totalHits < segmentCardinality / 10) {
                if (singleValues != null) {
                    int doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        this.increment((int)ordMap.get((long)singleValues.ordValue()));
                        ++this.totalDocCount;
                        doc = it.nextDoc();
                    }
                } else {
                    int doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        int term = (int)multiValues.nextOrd();
                        boolean countedDocInTotal = false;
                        while ((long)term != -1L) {
                            this.increment((int)ordMap.get((long)term));
                            if (!countedDocInTotal) {
                                ++this.totalDocCount;
                                countedDocInTotal = true;
                            }
                            term = (int)multiValues.nextOrd();
                        }
                        doc = it.nextDoc();
                    }
                }
            } else {
                int doc;
                int[] segCounts = new int[segmentCardinality];
                if (singleValues != null) {
                    doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        int n = singleValues.ordValue();
                        segCounts[n] = segCounts[n] + 1;
                        ++this.totalDocCount;
                        doc = it.nextDoc();
                    }
                } else {
                    doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        int term = (int)multiValues.nextOrd();
                        boolean countedDocInTotal = false;
                        while ((long)term != -1L) {
                            int n = term;
                            segCounts[n] = segCounts[n] + 1;
                            if (!countedDocInTotal) {
                                ++this.totalDocCount;
                                countedDocInTotal = true;
                            }
                            term = (int)multiValues.nextOrd();
                        }
                        doc = it.nextDoc();
                    }
                }
                for (int ord = 0; ord < segmentCardinality; ++ord) {
                    int count = segCounts[ord];
                    if (count == 0) continue;
                    this.increment((int)ordMap.get((long)ord), count);
                }
            }
        }
    }

    private void increment(int ordinal) {
        this.increment(ordinal, 1);
    }

    private void increment(int ordinal, int amount) {
        if (this.sparseCounts != null) {
            this.sparseCounts.addTo(ordinal, amount);
        } else {
            int n = ordinal;
            this.denseCounts[n] = this.denseCounts[n] + amount;
        }
    }

    private void validateState(LeafReaderContext context) {
        if (ReaderUtil.getTopLevelContext((IndexReaderContext)context).reader() != this.reader) {
            throw new IllegalStateException("the SortedSetDocValuesReaderState provided to this class does not match the reader being searched; you must create a new SortedSetDocValuesReaderState every time you open a new IndexReader");
        }
    }
}

