/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.DocValuesOrdinalsReader;
import org.apache.lucene.facet.taxonomy.FloatTaxonomyFacets;
import org.apache.lucene.facet.taxonomy.OrdinalsReader;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.IntsRef;

public class TaxonomyFacetSumValueSource
extends FloatTaxonomyFacets {
    private final OrdinalsReader ordinalsReader;

    @Deprecated
    public TaxonomyFacetSumValueSource(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, ValueSource valueSource) throws IOException {
        this((OrdinalsReader)new DocValuesOrdinalsReader("$facets"), taxoReader, config, fc, valueSource);
    }

    public TaxonomyFacetSumValueSource(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, DoubleValuesSource valueSource) throws IOException {
        this((OrdinalsReader)new DocValuesOrdinalsReader("$facets"), taxoReader, config, fc, valueSource);
    }

    @Deprecated
    public TaxonomyFacetSumValueSource(OrdinalsReader ordinalsReader, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, ValueSource valueSource) throws IOException {
        super(ordinalsReader.getIndexFieldName(), taxoReader, config);
        this.ordinalsReader = ordinalsReader;
        this.sumValues(fc.getMatchingDocs(), fc.getKeepScores(), valueSource.asDoubleValuesSource());
    }

    public TaxonomyFacetSumValueSource(OrdinalsReader ordinalsReader, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, DoubleValuesSource vs) throws IOException {
        super(ordinalsReader.getIndexFieldName(), taxoReader, config);
        this.ordinalsReader = ordinalsReader;
        this.sumValues(fc.getMatchingDocs(), fc.getKeepScores(), vs);
    }

    private static DoubleValues scores(final FacetsCollector.MatchingDocs hits) {
        return new DoubleValues(){
            int index = -1;

            public double doubleValue() throws IOException {
                return hits.scores[this.index];
            }

            public boolean advanceExact(int doc) throws IOException {
                ++this.index;
                return true;
            }
        };
    }

    private void sumValues(List<FacetsCollector.MatchingDocs> matchingDocs, boolean keepScores, DoubleValuesSource valueSource) throws IOException {
        IntsRef scratch = new IntsRef();
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            int doc;
            OrdinalsReader.OrdinalsSegmentReader ords = this.ordinalsReader.getReader(hits.context);
            DoubleValues scores = keepScores ? TaxonomyFacetSumValueSource.scores(hits) : null;
            DoubleValues functionValues = valueSource.getValues(hits.context, scores);
            DocIdSetIterator docs = hits.bits.iterator();
            while ((doc = docs.nextDoc()) != Integer.MAX_VALUE) {
                ords.get(doc, scratch);
                if (!functionValues.advanceExact(doc)) continue;
                float value = (float)functionValues.doubleValue();
                for (int i = 0; i < scratch.length; ++i) {
                    int n = scratch.ints[i];
                    this.values[n] = this.values[n] + value;
                }
            }
        }
        this.rollup();
    }

    public static class ScoreValueSource
    extends ValueSource {
        public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
            final Scorer scorer = (Scorer)context.get("scorer");
            if (scorer == null) {
                throw new IllegalStateException("scores are missing; be sure to pass keepScores=true to FacetsCollector");
            }
            return new DoubleDocValues(this){

                public double doubleVal(int document) {
                    try {
                        return scorer.score();
                    }
                    catch (IOException exception) {
                        throw new RuntimeException(exception);
                    }
                }
            };
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public String description() {
            return "score()";
        }
    }
}

