/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.search.CollectorManager;

class FacetsCollectorManager
implements CollectorManager<FacetsCollector, FacetsCollector> {
    public static final FacetsCollector EMPTY = new FacetsCollector();

    FacetsCollectorManager() {
    }

    public FacetsCollector newCollector() throws IOException {
        return new FacetsCollector();
    }

    public FacetsCollector reduce(Collection<FacetsCollector> collectors) throws IOException {
        if (collectors == null || collectors.size() == 0) {
            return EMPTY;
        }
        if (collectors.size() == 1) {
            return collectors.iterator().next();
        }
        return new ReducedFacetsCollector(collectors);
    }

    private static class ReducedFacetsCollector
    extends FacetsCollector {
        public ReducedFacetsCollector(Collection<FacetsCollector> facetsCollectors) {
            List<FacetsCollector.MatchingDocs> matchingDocs = this.getMatchingDocs();
            facetsCollectors.forEach(facetsCollector -> matchingDocs.addAll(facetsCollector.getMatchingDocs()));
        }
    }
}

