/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.facet.FacetQuery;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsQuery;

public class MultiFacetQuery
extends TermsQuery {
    public MultiFacetQuery(FacetsConfig facetsConfig, String dimension, String[] ... paths) {
        super(MultiFacetQuery.toTerms(facetsConfig.getDimConfig(dimension), dimension, paths));
    }

    public MultiFacetQuery(String dimension, String[] ... paths) {
        super(MultiFacetQuery.toTerms(FacetsConfig.DEFAULT_DIM_CONFIG, dimension, paths));
    }

    static Collection<Term> toTerms(FacetsConfig.DimConfig dimConfig, String dimension, String[] ... paths) {
        ArrayList<Term> terms = new ArrayList<Term>(paths.length);
        for (String[] path : paths) {
            terms.add(FacetQuery.toTerm(dimConfig, dimension, path));
        }
        return terms;
    }
}

