/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.writercache;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class CharBlockArray
implements Appendable,
Serializable,
CharSequence {
    private static final long serialVersionUID = 1L;
    private static final int DefaultBlockSize = 32768;
    List<Block> blocks = new ArrayList<Block>();
    Block current;
    int blockSize;
    int length;

    CharBlockArray() {
        this(32768);
    }

    CharBlockArray(int blockSize) {
        this.blockSize = blockSize;
        this.addBlock();
    }

    private void addBlock() {
        this.current = new Block(this.blockSize);
        this.blocks.add(this.current);
    }

    int blockIndex(int index) {
        return index / this.blockSize;
    }

    int indexInBlock(int index) {
        return index % this.blockSize;
    }

    @Override
    public CharBlockArray append(CharSequence chars) {
        return this.append(chars, 0, chars.length());
    }

    @Override
    public CharBlockArray append(char c) {
        if (this.current.length == this.blockSize) {
            this.addBlock();
        }
        this.current.chars[this.current.length++] = c;
        ++this.length;
        return this;
    }

    @Override
    public CharBlockArray append(CharSequence chars, int start, int length) {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            this.append(chars.charAt(i));
        }
        return this;
    }

    public CharBlockArray append(char[] chars, int start, int length) {
        int offset = start;
        int remain = length;
        while (remain > 0) {
            int toCopy;
            int remainingInBlock;
            if (this.current.length == this.blockSize) {
                this.addBlock();
            }
            if ((remainingInBlock = this.blockSize - this.current.length) < (toCopy = remain)) {
                toCopy = remainingInBlock;
            }
            System.arraycopy(chars, offset, this.current.chars, this.current.length, toCopy);
            offset += toCopy;
            remain -= toCopy;
            this.current.length += toCopy;
        }
        this.length += length;
        return this;
    }

    public CharBlockArray append(String s) {
        int remain = s.length();
        int offset = 0;
        while (remain > 0) {
            int toCopy;
            int remainingInBlock;
            if (this.current.length == this.blockSize) {
                this.addBlock();
            }
            if ((remainingInBlock = this.blockSize - this.current.length) < (toCopy = remain)) {
                toCopy = remainingInBlock;
            }
            s.getChars(offset, offset + toCopy, this.current.chars, this.current.length);
            offset += toCopy;
            remain -= toCopy;
            this.current.length += toCopy;
        }
        this.length += s.length();
        return this;
    }

    @Override
    public char charAt(int index) {
        Block b = this.blocks.get(this.blockIndex(index));
        return b.chars[this.indexInBlock(index)];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int numToAppend;
        int remaining;
        StringBuilder sb = new StringBuilder(remaining);
        int blockIdx = this.blockIndex(start);
        int indexInBlock = this.indexInBlock(start);
        for (remaining = end - start; remaining > 0; remaining -= numToAppend) {
            Block b = this.blocks.get(blockIdx++);
            numToAppend = Math.min(remaining, b.length - indexInBlock);
            sb.append(b.chars, indexInBlock, numToAppend);
            indexInBlock = 0;
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Block b : this.blocks) {
            sb.append(b.chars, 0, b.length);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush(OutputStream out) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(out);
            oos.writeObject(this);
            oos.flush();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharBlockArray open(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = null;
        try {
            CharBlockArray a;
            ois = new ObjectInputStream(in);
            CharBlockArray charBlockArray = a = (CharBlockArray)ois.readObject();
            return charBlockArray;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    static final class Block
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        final char[] chars;
        int length;

        Block(int size) {
            this.chars = new char[size];
            this.length = 0;
        }
    }
}

