/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.associations;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.facet.associations.CategoryAssociation;
import org.apache.lucene.facet.associations.CategoryAssociationsContainer;
import org.apache.lucene.facet.index.CategoryListBuilder;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public class AssociationsListBuilder
implements CategoryListBuilder {
    private final CategoryAssociationsContainer associations;
    private final ByteArrayDataOutput output = new ByteArrayDataOutput();

    public AssociationsListBuilder(CategoryAssociationsContainer associations) {
        this.associations = associations;
    }

    @Override
    public Map<String, BytesRef> build(IntsRef ordinals, Iterable<CategoryPath> categories) throws IOException {
        HashMap<String, BytesRef> res = new HashMap<String, BytesRef>();
        int idx = 0;
        for (CategoryPath cp : categories) {
            int maxBytesNeeded;
            CategoryAssociation association = this.associations.getAssociation(cp);
            BytesRef bytes = res.get(association.getCategoryListID());
            if (bytes == null) {
                bytes = new BytesRef(32);
                res.put(association.getCategoryListID(), bytes);
            }
            if (bytes.bytes.length < (maxBytesNeeded = 4 + association.maxBytesNeeded() + bytes.length)) {
                bytes.grow(maxBytesNeeded);
            }
            this.output.reset(bytes.bytes, bytes.length, bytes.bytes.length - bytes.length);
            this.output.writeInt(ordinals.ints[idx++]);
            association.serialize(this.output);
            bytes.length = this.output.getPosition();
        }
        return res;
    }
}

