/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.FixedBitSet;

public abstract class FacetsCollector
extends Collector {
    private final FacetsAccumulator accumulator;
    private List<FacetResult> cachedResults;
    protected final List<MatchingDocs> matchingDocs = new ArrayList<MatchingDocs>();

    public static FacetsCollector create(FacetSearchParams fsp, IndexReader indexReader, TaxonomyReader taxoReader) {
        return FacetsCollector.create(FacetsAccumulator.create(fsp, indexReader, taxoReader));
    }

    public static FacetsCollector create(FacetsAccumulator accumulator) {
        if (accumulator.requiresDocScores()) {
            return new DocsAndScoresCollector(accumulator);
        }
        return new DocsOnlyCollector(accumulator);
    }

    protected FacetsCollector(FacetsAccumulator accumulator) {
        this.accumulator = accumulator;
    }

    protected abstract void finish();

    protected abstract void doSetNextReader(AtomicReaderContext var1) throws IOException;

    public final List<FacetResult> getFacetResults() throws IOException {
        if (this.cachedResults == null) {
            this.finish();
            this.cachedResults = this.accumulator.accumulate(this.matchingDocs);
        }
        return this.cachedResults;
    }

    public final List<MatchingDocs> getMatchingDocs() {
        this.finish();
        return this.matchingDocs;
    }

    public final void reset() {
        this.finish();
        this.matchingDocs.clear();
        this.cachedResults = null;
    }

    public final void setNextReader(AtomicReaderContext context) throws IOException {
        this.cachedResults = null;
        this.doSetNextReader(context);
    }

    public static final class MatchingDocs {
        public final AtomicReaderContext context;
        public final FixedBitSet bits;
        public final float[] scores;
        public final int totalHits;

        public MatchingDocs(AtomicReaderContext context, FixedBitSet bits, int totalHits, float[] scores) {
            this.context = context;
            this.bits = bits;
            this.scores = scores;
            this.totalHits = totalHits;
        }
    }

    private static final class DocsOnlyCollector
    extends FacetsCollector {
        private AtomicReaderContext context;
        private FixedBitSet bits;
        private int totalHits;

        public DocsOnlyCollector(FacetsAccumulator accumulator) {
            super(accumulator);
        }

        @Override
        protected final void finish() {
            if (this.bits != null) {
                this.matchingDocs.add(new MatchingDocs(this.context, this.bits, this.totalHits, null));
                this.bits = null;
                this.context = null;
            }
        }

        public final boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public final void collect(int doc) throws IOException {
            ++this.totalHits;
            this.bits.set(doc);
        }

        public final void setScorer(Scorer scorer) throws IOException {
        }

        @Override
        protected final void doSetNextReader(AtomicReaderContext context) throws IOException {
            if (this.bits != null) {
                this.matchingDocs.add(new MatchingDocs(this.context, this.bits, this.totalHits, null));
            }
            this.bits = new FixedBitSet(context.reader().maxDoc());
            this.totalHits = 0;
            this.context = context;
        }
    }

    private static final class DocsAndScoresCollector
    extends FacetsCollector {
        private AtomicReaderContext context;
        private Scorer scorer;
        private FixedBitSet bits;
        private int totalHits;
        private float[] scores;

        public DocsAndScoresCollector(FacetsAccumulator accumulator) {
            super(accumulator);
        }

        @Override
        protected final void finish() {
            if (this.bits != null) {
                this.matchingDocs.add(new MatchingDocs(this.context, this.bits, this.totalHits, this.scores));
                this.bits = null;
                this.scores = null;
                this.context = null;
            }
        }

        public final boolean acceptsDocsOutOfOrder() {
            return false;
        }

        public final void collect(int doc) throws IOException {
            this.bits.set(doc);
            if (this.totalHits >= this.scores.length) {
                float[] newScores = new float[ArrayUtil.oversize((int)(this.totalHits + 1), (int)4)];
                System.arraycopy(this.scores, 0, newScores, 0, this.totalHits);
                this.scores = newScores;
            }
            this.scores[this.totalHits] = this.scorer.score();
            ++this.totalHits;
        }

        public final void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        protected final void doSetNextReader(AtomicReaderContext context) throws IOException {
            if (this.bits != null) {
                this.matchingDocs.add(new MatchingDocs(this.context, this.bits, this.totalHits, this.scores));
            }
            this.bits = new FixedBitSet(context.reader().maxDoc());
            this.totalHits = 0;
            this.scores = new float[64];
            this.context = context;
        }
    }
}

