/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sampling;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.sampling.SamplingParams;
import org.apache.lucene.facet.search.Aggregator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

public abstract class Sampler {
    protected final SamplingParams samplingParams;

    public Sampler() {
        this(new SamplingParams());
    }

    public Sampler(SamplingParams params) throws IllegalArgumentException {
        if (!params.validate()) {
            throw new IllegalArgumentException("The provided SamplingParams are not valid!!");
        }
        this.samplingParams = params;
    }

    public boolean shouldSample(ScoredDocIDs docIds) {
        return docIds.size() > this.samplingParams.getSamplingThreshold();
    }

    public SampleResult getSampleSet(ScoredDocIDs docids) throws IOException {
        if (!this.shouldSample(docids)) {
            return new SampleResult(docids, 1.0);
        }
        int actualSize = docids.size();
        int sampleSetSize = (int)((double)actualSize * this.samplingParams.getSampleRatio());
        sampleSetSize = Math.max(sampleSetSize, this.samplingParams.getMinSampleSize());
        sampleSetSize = Math.min(sampleSetSize, this.samplingParams.getMaxSampleSize());
        return this.createSample(docids, actualSize, sampleSetSize);
    }

    protected abstract SampleResult createSample(ScoredDocIDs var1, int var2, int var3) throws IOException;

    public final SamplingParams getSamplingParams() {
        return this.samplingParams;
    }

    public FacetResult trimResult(FacetResult facetResult) throws IllegalArgumentException {
        double overSampleFactor = this.getSamplingParams().getOversampleFactor();
        if (overSampleFactor <= 1.0) {
            return facetResult;
        }
        OverSampledFacetRequest sampledFreq = null;
        try {
            sampledFreq = (OverSampledFacetRequest)facetResult.getFacetRequest();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("It is only valid to call this method with result obtained for a facet request created through sampler.overSamlpingSearchParams()", e);
        }
        FacetRequest origFrq = sampledFreq.orig;
        FacetResultNode trimmedRootNode = facetResult.getFacetResultNode();
        this.trimSubResults(trimmedRootNode, origFrq.numResults);
        return new FacetResult(origFrq, trimmedRootNode, facetResult.getNumValidDescendants());
    }

    private void trimSubResults(FacetResultNode node, int size) {
        if (node.subResults == FacetResultNode.EMPTY_SUB_RESULTS || node.subResults.size() == 0) {
            return;
        }
        ArrayList<FacetResultNode> trimmed = new ArrayList<FacetResultNode>(size);
        for (int i = 0; i < node.subResults.size() && i < size; ++i) {
            FacetResultNode trimmedNode = node.subResults.get(i);
            this.trimSubResults(trimmedNode, size);
            trimmed.add(trimmedNode);
        }
        node.subResults = trimmed;
    }

    public FacetSearchParams overSampledSearchParams(FacetSearchParams original) {
        FacetSearchParams res = original;
        double overSampleFactor = this.getSamplingParams().getOversampleFactor();
        if (overSampleFactor > 1.0) {
            ArrayList<FacetRequest> facetRequests = new ArrayList<FacetRequest>();
            for (FacetRequest frq : original.facetRequests) {
                int overSampledNumResults = (int)Math.ceil((double)frq.numResults * overSampleFactor);
                facetRequests.add(new OverSampledFacetRequest(frq, overSampledNumResults));
            }
            res = new FacetSearchParams(original.indexingParams, facetRequests);
        }
        return res;
    }

    private static class OverSampledFacetRequest
    extends FacetRequest {
        final FacetRequest orig;

        public OverSampledFacetRequest(FacetRequest orig, int num) {
            super(orig.categoryPath, num);
            this.orig = orig;
            this.setDepth(orig.getDepth());
            this.setNumLabel(0);
            this.setResultMode(orig.getResultMode());
            this.setSortOrder(orig.getSortOrder());
        }

        @Override
        public Aggregator createAggregator(boolean useComplements, FacetArrays arrays, TaxonomyReader taxonomy) throws IOException {
            return this.orig.createAggregator(useComplements, arrays, taxonomy);
        }

        @Override
        public FacetRequest.FacetArraysSource getFacetArraysSource() {
            return this.orig.getFacetArraysSource();
        }

        @Override
        public double getValueOf(FacetArrays arrays, int idx) {
            return this.orig.getValueOf(arrays, idx);
        }
    }

    public static final class SampleResult {
        public final ScoredDocIDs docids;
        public final double actualSampleRatio;

        protected SampleResult(ScoredDocIDs docids, double actualSampleRatio) {
            this.docids = docids;
            this.actualSampleRatio = actualSampleRatio;
        }
    }
}

