/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.search.CountFacetRequest;
import org.apache.lucene.facet.search.CountingFacetsAggregator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.FacetResultsHandler;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.FastCountingFacetsAggregator;
import org.apache.lucene.facet.search.FloatFacetResultsHandler;
import org.apache.lucene.facet.search.IntFacetResultsHandler;
import org.apache.lucene.facet.search.StandardFacetsAccumulator;
import org.apache.lucene.facet.search.TopKFacetResultsHandler;
import org.apache.lucene.facet.search.TopKInEachNodeHandler;
import org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public class FacetsAccumulator {
    public final TaxonomyReader taxonomyReader;
    public final IndexReader indexReader;
    public final FacetArrays facetArrays;
    public FacetSearchParams searchParams;

    public FacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader) {
        this(searchParams, indexReader, taxonomyReader, new FacetArrays(taxonomyReader.getSize()));
    }

    public static FacetsAccumulator create(FacetSearchParams fsp, IndexReader indexReader, TaxonomyReader taxoReader) {
        if (fsp.indexingParams.getPartitionSize() != Integer.MAX_VALUE) {
            return new StandardFacetsAccumulator(fsp, indexReader, taxoReader);
        }
        for (FacetRequest fr : fsp.facetRequests) {
            if (fr instanceof CountFacetRequest) continue;
            return new StandardFacetsAccumulator(fsp, indexReader, taxoReader);
        }
        return new FacetsAccumulator(fsp, indexReader, taxoReader);
    }

    protected static FacetResult emptyResult(int ordinal, FacetRequest fr) {
        FacetResultNode root = new FacetResultNode(ordinal, 0.0);
        root.label = fr.categoryPath;
        return new FacetResult(fr, root, 0);
    }

    public FacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader, FacetArrays facetArrays) {
        this.facetArrays = facetArrays;
        this.indexReader = indexReader;
        this.taxonomyReader = taxonomyReader;
        this.searchParams = searchParams;
    }

    public FacetsAggregator getAggregator() {
        if (FastCountingFacetsAggregator.verifySearchParams(this.searchParams)) {
            return new FastCountingFacetsAggregator();
        }
        return new CountingFacetsAggregator();
    }

    protected FacetResultsHandler createFacetResultsHandler(FacetRequest fr) {
        if (fr.getDepth() == 1 && fr.getSortOrder() == FacetRequest.SortOrder.DESCENDING) {
            FacetRequest.FacetArraysSource fas = fr.getFacetArraysSource();
            if (fas == FacetRequest.FacetArraysSource.INT) {
                return new IntFacetResultsHandler(this.taxonomyReader, fr, this.facetArrays);
            }
            if (fas == FacetRequest.FacetArraysSource.FLOAT) {
                return new FloatFacetResultsHandler(this.taxonomyReader, fr, this.facetArrays);
            }
        }
        if (fr.getResultMode() == FacetRequest.ResultMode.PER_NODE_IN_TREE) {
            return new TopKInEachNodeHandler(this.taxonomyReader, fr, this.facetArrays);
        }
        return new TopKFacetResultsHandler(this.taxonomyReader, fr, this.facetArrays);
    }

    protected Set<CategoryListParams> getCategoryLists() {
        if (this.searchParams.indexingParams.getAllCategoryListParams().size() == 1) {
            return Collections.singleton(this.searchParams.indexingParams.getCategoryListParams(null));
        }
        HashSet<CategoryListParams> clps = new HashSet<CategoryListParams>();
        for (FacetRequest fr : this.searchParams.facetRequests) {
            clps.add(this.searchParams.indexingParams.getCategoryListParams(fr.categoryPath));
        }
        return clps;
    }

    public List<FacetResult> accumulate(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        FacetsAggregator aggregator = this.getAggregator();
        for (CategoryListParams clp : this.getCategoryLists()) {
            for (FacetsCollector.MatchingDocs md : matchingDocs) {
                aggregator.aggregate(md, clp, this.facetArrays);
            }
        }
        ParallelTaxonomyArrays arrays = this.taxonomyReader.getParallelTaxonomyArrays();
        int[] children = arrays.children();
        int[] siblings = arrays.siblings();
        ArrayList<FacetResult> res = new ArrayList<FacetResult>();
        for (FacetRequest fr : this.searchParams.facetRequests) {
            CategoryListParams.OrdinalPolicy ordinalPolicy;
            int rootOrd = this.taxonomyReader.getOrdinal(fr.categoryPath);
            if (rootOrd == -1) {
                res.add(FacetsAccumulator.emptyResult(rootOrd, fr));
                continue;
            }
            CategoryListParams clp = this.searchParams.indexingParams.getCategoryListParams(fr.categoryPath);
            if (fr.categoryPath.length > 0 && (ordinalPolicy = clp.getOrdinalPolicy(fr.categoryPath.components[0])) == CategoryListParams.OrdinalPolicy.NO_PARENTS) {
                aggregator.rollupValues(fr, rootOrd, children, siblings, this.facetArrays);
            }
            FacetResultsHandler frh = this.createFacetResultsHandler(fr);
            res.add(frh.compute());
        }
        return res;
    }

    public boolean requiresDocScores() {
        return this.getAggregator().requiresDocScores();
    }
}

