/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sampling;

import java.io.IOException;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.ScoredDocIDs;

public abstract class SampleFixer {
    public void fixResult(ScoredDocIDs origDocIds, FacetResult fres, double samplingRatio) throws IOException {
        FacetResultNode topRes = fres.getFacetResultNode();
        this.fixResultNode(topRes, origDocIds, samplingRatio);
    }

    protected void fixResultNode(FacetResultNode facetResNode, ScoredDocIDs docIds, double samplingRatio) throws IOException {
        this.singleNodeFix(facetResNode, docIds, samplingRatio);
        for (FacetResultNode frn : facetResNode.subResults) {
            this.fixResultNode(frn, docIds, samplingRatio);
        }
    }

    protected abstract void singleNodeFix(FacetResultNode var1, ScoredDocIDs var2, double var3) throws IOException;
}

