/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.facet.range.RangeFacetRequest;
import org.apache.lucene.facet.range.RangeFacetResultNode;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.NumericDocValues;

public class RangeAccumulator
extends FacetsAccumulator {
    final List<RangeSet> requests = new ArrayList<RangeSet>();

    public RangeAccumulator(FacetSearchParams fsp, IndexReader reader) {
        super(fsp, reader, null, null);
        for (FacetRequest fr : fsp.facetRequests) {
            if (!(fr instanceof RangeFacetRequest)) {
                throw new IllegalArgumentException("only RangeFacetRequest is supported; got " + fsp.facetRequests.get(0).getClass());
            }
            if (fr.categoryPath.length != 1) {
                throw new IllegalArgumentException("only flat (dimension only) CategoryPath is allowed");
            }
            RangeFacetRequest rfr = (RangeFacetRequest)fr;
            this.requests.add(new RangeSet(rfr.ranges, rfr.categoryPath.components[0]));
        }
    }

    @Override
    public FacetsAggregator getAggregator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FacetResult> accumulate(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        for (int i = 0; i < this.requests.size(); ++i) {
            RangeSet ranges = this.requests.get(i);
            int[] counts = new int[ranges.ranges.length];
            for (FacetsCollector.MatchingDocs hits : matchingDocs) {
                NumericDocValues ndv = hits.context.reader().getNumericDocValues(ranges.field);
                if (ndv == null) continue;
                int length = hits.bits.length();
                for (int doc = 0; doc < length && (doc = hits.bits.nextSetBit(doc)) != -1; ++doc) {
                    long v = ndv.get(doc);
                    for (int j = 0; j < ranges.ranges.length; ++j) {
                        if (!ranges.ranges[j].accept(v)) continue;
                        int n = j;
                        counts[n] = counts[n] + 1;
                    }
                }
            }
            ArrayList<FacetResultNode> nodes = new ArrayList<FacetResultNode>(ranges.ranges.length);
            for (int j = 0; j < ranges.ranges.length; ++j) {
                nodes.add(new RangeFacetResultNode(ranges.field, ranges.ranges[j], counts[j]));
            }
            FacetResultNode rootNode = new FacetResultNode(-1, 0.0);
            rootNode.label = new CategoryPath(ranges.field);
            rootNode.subResults = nodes;
            results.add(new FacetResult(this.searchParams.facetRequests.get(i), rootNode, nodes.size()));
        }
        return results;
    }

    @Override
    public boolean requiresDocScores() {
        return false;
    }

    static class RangeSet {
        final Range[] ranges;
        final String field;

        public RangeSet(Range[] ranges, String field) {
            this.ranges = ranges;
            this.field = field;
        }
    }
}

