/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.collections;

import java.util.Arrays;
import org.apache.lucene.facet.collections.FloatIterator;
import org.apache.lucene.facet.collections.IntIterator;

public class IntToFloatMap {
    public static final float GROUND = Float.NaN;
    private static int defaultCapacity = 16;
    int[] baseHash;
    private int capacity = 16;
    private int firstEmpty;
    private int hashFactor;
    int[] keys;
    int[] next;
    private int prev;
    private int size;
    float[] values;

    public IntToFloatMap() {
        this(defaultCapacity);
    }

    public IntToFloatMap(int capacity) {
        while (this.capacity < capacity) {
            this.capacity <<= 1;
        }
        int arrayLength = this.capacity + 1;
        this.values = new float[arrayLength];
        this.keys = new int[arrayLength];
        this.next = new int[arrayLength];
        int baseHashSize = this.capacity << 1;
        this.baseHash = new int[baseHashSize];
        this.values[0] = Float.NaN;
        this.hashFactor = baseHashSize - 1;
        this.size = 0;
        this.clear();
    }

    private void prvt_put(int key, float v) {
        int hashIndex = this.calcBaseHashIndex(key);
        int objectIndex = this.firstEmpty;
        this.firstEmpty = this.next[this.firstEmpty];
        this.values[objectIndex] = v;
        this.keys[objectIndex] = key;
        this.next[objectIndex] = this.baseHash[hashIndex];
        this.baseHash[hashIndex] = objectIndex;
        ++this.size;
    }

    protected int calcBaseHashIndex(int key) {
        return key & this.hashFactor;
    }

    public void clear() {
        Arrays.fill(this.baseHash, 0);
        this.size = 0;
        this.firstEmpty = 1;
        int i = 1;
        while (i < this.capacity) {
            this.next[i++] = i;
        }
        this.next[this.capacity] = 0;
    }

    public boolean containsKey(int key) {
        return this.find(key) != 0;
    }

    public boolean containsValue(float value) {
        FloatIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            float d = iterator.next();
            if (d != value) continue;
            return true;
        }
        return false;
    }

    protected int find(int key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int localIndex = this.baseHash[baseHashIndex];
        while (localIndex != 0) {
            if (this.keys[localIndex] == key) {
                return localIndex;
            }
            localIndex = this.next[localIndex];
        }
        return 0;
    }

    private int findForRemove(int key, int baseHashIndex) {
        this.prev = 0;
        int index = this.baseHash[baseHashIndex];
        while (index != 0) {
            if (this.keys[index] == key) {
                return index;
            }
            this.prev = index;
            index = this.next[index];
        }
        this.prev = 0;
        return 0;
    }

    public float get(int key) {
        return this.values[this.find(key)];
    }

    protected void grow() {
        IntToFloatMap that = new IntToFloatMap(this.capacity * 2);
        IndexIterator iterator = new IndexIterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            that.prvt_put(this.keys[index], this.values[index]);
        }
        this.capacity = that.capacity;
        this.size = that.size;
        this.firstEmpty = that.firstEmpty;
        this.values = that.values;
        this.keys = that.keys;
        this.next = that.next;
        this.baseHash = that.baseHash;
        this.hashFactor = that.hashFactor;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public FloatIterator iterator() {
        return new ValueIterator();
    }

    public IntIterator keyIterator() {
        return new KeyIterator();
    }

    private String getBaseHashAsString() {
        return Arrays.toString(this.baseHash);
    }

    public float put(int key, float v) {
        int index = this.find(key);
        if (index != 0) {
            float old = this.values[index];
            this.values[index] = v;
            return old;
        }
        if (this.size == this.capacity) {
            this.grow();
        }
        this.prvt_put(key, v);
        return Float.NaN;
    }

    public float remove(int key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int index = this.findForRemove(key, baseHashIndex);
        if (index != 0) {
            if (this.prev == 0) {
                this.baseHash[baseHashIndex] = this.next[index];
            }
            this.next[this.prev] = this.next[index];
            this.next[index] = this.firstEmpty;
            this.firstEmpty = index;
            --this.size;
            return this.values[index];
        }
        return Float.NaN;
    }

    public int size() {
        return this.size;
    }

    public float[] toArray() {
        int j = -1;
        float[] array = new float[this.size];
        FloatIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            array[++j] = iterator.next();
        }
        return array;
    }

    public float[] toArray(float[] a) {
        int j = 0;
        if (a.length < this.size()) {
            a = new float[this.size()];
        }
        FloatIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            a[j] = iterator.next();
            ++j;
        }
        if (j < a.length) {
            a[j] = Float.NaN;
        }
        return a;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        IntIterator keyIterator = this.keyIterator();
        while (keyIterator.hasNext()) {
            int key = keyIterator.next();
            sb.append(key);
            sb.append('=');
            sb.append(this.get(key));
            if (!keyIterator.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.size();
    }

    public boolean equals(Object o) {
        IntToFloatMap that = (IntToFloatMap)o;
        if (that.size() != this.size()) {
            return false;
        }
        IntIterator it = this.keyIterator();
        while (it.hasNext()) {
            float v2;
            int key = it.next();
            if (!that.containsKey(key)) {
                return false;
            }
            float v1 = this.get(key);
            if (Float.compare(v1, v2 = that.get(key)) == 0) continue;
            return false;
        }
        return true;
    }

    private final class ValueIterator
    implements FloatIterator {
        private IntIterator iterator;

        ValueIterator() {
            this.iterator = new IndexIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public float next() {
            return IntToFloatMap.this.values[this.iterator.next()];
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class KeyIterator
    implements IntIterator {
        private IntIterator iterator;

        KeyIterator() {
            this.iterator = new IndexIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public int next() {
            return IntToFloatMap.this.keys[this.iterator.next()];
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class IndexIterator
    implements IntIterator {
        private int baseHashIndex = 0;
        private int index = 0;
        private int lastIndex = 0;

        public IndexIterator() {
            while (this.baseHashIndex < IntToFloatMap.this.baseHash.length) {
                this.index = IntToFloatMap.this.baseHash[this.baseHashIndex];
                if (this.index != 0) break;
                ++this.baseHashIndex;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index != 0;
        }

        @Override
        public int next() {
            this.lastIndex = this.index;
            this.index = IntToFloatMap.this.next[this.index];
            while (this.index == 0 && ++this.baseHashIndex < IntToFloatMap.this.baseHash.length) {
                this.index = IntToFloatMap.this.baseHash[this.baseHashIndex];
            }
            return this.lastIndex;
        }

        @Override
        public void remove() {
            IntToFloatMap.this.remove(IntToFloatMap.this.keys[this.lastIndex]);
        }
    }
}

