/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

public final class PartitionsUtils {
    public static final String PART_NAME_PREFIX = "$part";

    public static final int partitionSize(FacetIndexingParams indexingParams, TaxonomyReader taxonomyReader) {
        return Math.min(indexingParams.getPartitionSize(), taxonomyReader.getSize());
    }

    public static final int partitionNumber(FacetIndexingParams iParams, int ordinal) {
        return ordinal / iParams.getPartitionSize();
    }

    public static final String partitionNameByOrdinal(FacetIndexingParams iParams, int ordinal) {
        int partition = PartitionsUtils.partitionNumber(iParams, ordinal);
        return PartitionsUtils.partitionName(partition);
    }

    public static final String partitionName(int partition) {
        if (partition == 0) {
            return "";
        }
        return PART_NAME_PREFIX + Integer.toString(partition);
    }
}

