/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sortedset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.search.CountFacetRequest;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

public class SortedSetDocValuesAccumulator
extends FacetsAccumulator {
    final SortedSetDocValuesReaderState state;
    final SortedSetDocValues dv;
    final String field;

    public SortedSetDocValuesAccumulator(FacetSearchParams fsp, SortedSetDocValuesReaderState state) throws IOException {
        super(fsp, null, null, new FacetArrays(state.getSize()));
        this.state = state;
        this.field = state.getField();
        this.dv = state.getDocValues();
        for (FacetRequest request : fsp.facetRequests) {
            if (!(request instanceof CountFacetRequest)) {
                throw new IllegalArgumentException("this collector only supports CountFacetRequest; got " + request);
            }
            if (request.categoryPath.length != 1) {
                throw new IllegalArgumentException("this collector only supports depth 1 CategoryPath; got " + request.categoryPath);
            }
            if (request.getDepth() != 1) {
                throw new IllegalArgumentException("this collector only supports depth=1; got " + request.getDepth());
            }
            String dim = request.categoryPath.components[0];
            SortedSetDocValuesReaderState.OrdRange ordRange = state.getOrdRange(dim);
            if (ordRange != null) continue;
            throw new IllegalArgumentException("dim \"" + dim + "\" does not exist");
        }
    }

    @Override
    public FacetsAggregator getAggregator() {
        return new FacetsAggregator(){

            @Override
            public void aggregate(FacetsCollector.MatchingDocs matchingDocs, CategoryListParams clp, FacetArrays facetArrays) throws IOException {
                AtomicReader reader = matchingDocs.context.reader();
                if (ReaderUtil.getTopLevelContext((IndexReaderContext)matchingDocs.context).reader() != SortedSetDocValuesAccumulator.this.state.origReader) {
                    throw new IllegalStateException("the SortedSetDocValuesReaderState provided to this class does not match the reader being searched; you must create a new SortedSetDocValuesReaderState every time you open a new IndexReader");
                }
                SortedSetDocValues segValues = reader.getSortedSetDocValues(SortedSetDocValuesAccumulator.this.field);
                if (segValues == null) {
                    return;
                }
                int[] counts = facetArrays.getIntArray();
                int maxDoc = reader.maxDoc();
                assert (maxDoc == matchingDocs.bits.length());
                if (SortedSetDocValuesAccumulator.this.dv instanceof MultiDocValues.MultiSortedSetDocValues) {
                    MultiDocValues.OrdinalMap ordinalMap = ((MultiDocValues.MultiSortedSetDocValues)SortedSetDocValuesAccumulator.this.dv).mapping;
                    int segOrd = matchingDocs.context.ord;
                    int numSegOrds = (int)segValues.getValueCount();
                    if (matchingDocs.totalHits < numSegOrds / 10) {
                        for (int doc = 0; doc < maxDoc && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
                            segValues.setDocument(doc);
                            int term = (int)segValues.nextOrd();
                            while ((long)term != -1L) {
                                int n = (int)ordinalMap.getGlobalOrd(segOrd, (long)term);
                                counts[n] = counts[n] + 1;
                                term = (int)segValues.nextOrd();
                            }
                        }
                    } else {
                        int[] segCounts = new int[numSegOrds];
                        for (int doc = 0; doc < maxDoc && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
                            segValues.setDocument(doc);
                            int term = (int)segValues.nextOrd();
                            while ((long)term != -1L) {
                                int n = term;
                                segCounts[n] = segCounts[n] + 1;
                                term = (int)segValues.nextOrd();
                            }
                        }
                        for (int ord = 0; ord < numSegOrds; ++ord) {
                            int count = segCounts[ord];
                            if (count == 0) continue;
                            int n = (int)ordinalMap.getGlobalOrd(segOrd, (long)ord);
                            counts[n] = counts[n] + count;
                        }
                    }
                } else {
                    for (int doc = 0; doc < maxDoc && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
                        segValues.setDocument(doc);
                        int term = (int)segValues.nextOrd();
                        while ((long)term != -1L) {
                            int n = term;
                            counts[n] = counts[n] + 1;
                            term = (int)segValues.nextOrd();
                        }
                    }
                }
            }

            @Override
            public void rollupValues(FacetRequest fr, int ordinal, int[] children, int[] siblings, FacetArrays facetArrays) {
            }

            @Override
            public boolean requiresDocScores() {
                return false;
            }
        };
    }

    @Override
    public List<FacetResult> accumulate(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        FacetsAggregator aggregator = this.getAggregator();
        for (CategoryListParams clp : this.getCategoryLists()) {
            for (FacetsCollector.MatchingDocs md : matchingDocs) {
                aggregator.aggregate(md, clp, this.facetArrays);
            }
        }
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        int[] counts = this.facetArrays.getIntArray();
        BytesRef scratch = new BytesRef();
        for (FacetRequest request : this.searchParams.facetRequests) {
            String dim = request.categoryPath.components[0];
            SortedSetDocValuesReaderState.OrdRange ordRange = this.state.getOrdRange(dim);
            assert (ordRange != null);
            if (request.numResults >= ordRange.end - ordRange.start + 1) {
                ArrayList<FacetResultNode> nodes = new ArrayList<FacetResultNode>();
                int dimCount = 0;
                for (int ord = ordRange.start; ord <= ordRange.end; ++ord) {
                    if (counts[ord] == 0) continue;
                    dimCount += counts[ord];
                    FacetResultNode node = new FacetResultNode(ord, counts[ord]);
                    this.dv.lookupOrd((long)ord, scratch);
                    node.label = new CategoryPath(scratch.utf8ToString().split(this.state.separatorRegex, 2));
                    nodes.add(node);
                }
                Collections.sort(nodes, new Comparator<FacetResultNode>(){

                    @Override
                    public int compare(FacetResultNode o1, FacetResultNode o2) {
                        int value = (int)(o2.value - o1.value);
                        if (value == 0) {
                            value = o1.ordinal - o2.ordinal;
                        }
                        return value;
                    }
                });
                CategoryListParams.OrdinalPolicy op = this.searchParams.indexingParams.getCategoryListParams(request.categoryPath).getOrdinalPolicy(dim);
                if (op == CategoryListParams.OrdinalPolicy.ALL_BUT_DIMENSION) {
                    dimCount = 0;
                }
                FacetResultNode rootNode = new FacetResultNode(-1, dimCount);
                rootNode.label = new CategoryPath(dim);
                rootNode.subResults = nodes;
                results.add(new FacetResult(request, rootNode, nodes.size()));
                continue;
            }
            TopCountPQ q = new TopCountPQ(request.numResults);
            int bottomCount = 0;
            int dimCount = 0;
            int childCount = 0;
            FacetResultNode reuse = null;
            for (int ord = ordRange.start; ord <= ordRange.end; ++ord) {
                if (counts[ord] <= 0) continue;
                ++childCount;
                if (counts[ord] <= bottomCount) continue;
                dimCount += counts[ord];
                if (reuse == null) {
                    reuse = new FacetResultNode(ord, counts[ord]);
                } else {
                    reuse.ordinal = ord;
                    reuse.value = counts[ord];
                }
                reuse = (FacetResultNode)q.insertWithOverflow(reuse);
                if (q.size() != request.numResults) continue;
                bottomCount = (int)((FacetResultNode)q.top()).value;
            }
            CategoryListParams.OrdinalPolicy op = this.searchParams.indexingParams.getCategoryListParams(request.categoryPath).getOrdinalPolicy(dim);
            if (op == CategoryListParams.OrdinalPolicy.ALL_BUT_DIMENSION) {
                dimCount = 0;
            }
            FacetResultNode rootNode = new FacetResultNode(-1, dimCount);
            rootNode.label = new CategoryPath(dim);
            FacetResultNode[] childNodes = new FacetResultNode[q.size()];
            for (int i = childNodes.length - 1; i >= 0; --i) {
                childNodes[i] = (FacetResultNode)q.pop();
                this.dv.lookupOrd((long)childNodes[i].ordinal, scratch);
                childNodes[i].label = new CategoryPath(scratch.utf8ToString().split(this.state.separatorRegex, 2));
            }
            rootNode.subResults = Arrays.asList(childNodes);
            results.add(new FacetResult(request, rootNode, childCount));
        }
        return results;
    }

    static class TopCountPQ
    extends PriorityQueue<FacetResultNode> {
        public TopCountPQ(int topN) {
            super(topN, false);
        }

        protected boolean lessThan(FacetResultNode a, FacetResultNode b) {
            if (a.value < b.value) {
                return true;
            }
            if (a.value > b.value) {
                return false;
            }
            return a.ordinal > b.ordinal;
        }
    }
}

