/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.codecs.facet42;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.packed.PackedInts;

class Facet42BinaryDocValues
extends BinaryDocValues {
    private final byte[] bytes;
    private final PackedInts.Reader addresses;

    Facet42BinaryDocValues(DataInput in) throws IOException {
        int totBytes = in.readVInt();
        this.bytes = new byte[totBytes];
        in.readBytes(this.bytes, 0, totBytes);
        this.addresses = PackedInts.getReader((DataInput)in);
    }

    public void get(int docID, BytesRef ret) {
        int start = (int)this.addresses.get(docID);
        ret.bytes = this.bytes;
        ret.offset = start;
        ret.length = (int)(this.addresses.get(docID + 1) - (long)start);
    }
}

