/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sortedset;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;

public final class SortedSetDocValuesReaderState {
    private final String field;
    private final AtomicReader topReader;
    private final int valueCount;
    final IndexReader origReader;
    final char separator;
    final String separatorRegex;
    public static final String FACET_FIELD_EXTENSION = "_sorted_doc_values";
    private final Map<String, OrdRange> prefixToOrdRange = new HashMap<String, OrdRange>();

    public SortedSetDocValuesReaderState(IndexReader reader) throws IOException {
        this(FacetIndexingParams.DEFAULT, reader);
    }

    public SortedSetDocValuesReaderState(FacetIndexingParams fip, IndexReader reader) throws IOException {
        this.field = fip.getCategoryListParams(null).field + FACET_FIELD_EXTENSION;
        this.separator = fip.getFacetDelimChar();
        this.separatorRegex = Pattern.quote(Character.toString(this.separator));
        this.origReader = reader;
        this.topReader = reader instanceof AtomicReader ? (AtomicReader)reader : new SlowCompositeReaderWrapper((CompositeReader)reader);
        SortedSetDocValues dv = this.topReader.getSortedSetDocValues(this.field);
        if (dv == null) {
            throw new IllegalArgumentException("field \"" + this.field + "\" was not indexed with SortedSetDocValues");
        }
        if (dv.getValueCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("can only handle valueCount < Integer.MAX_VALUE; got " + dv.getValueCount());
        }
        this.valueCount = (int)dv.getValueCount();
        String lastDim = null;
        int startOrd = -1;
        BytesRef spare = new BytesRef();
        for (int ord = 0; ord < this.valueCount; ++ord) {
            dv.lookupOrd((long)ord, spare);
            String[] components = spare.utf8ToString().split(this.separatorRegex, 2);
            if (components.length != 2) {
                throw new IllegalArgumentException("this class can only handle 2 level hierarchy (dim/value); got: " + spare.utf8ToString());
            }
            if (components[0].equals(lastDim)) continue;
            if (lastDim != null) {
                this.prefixToOrdRange.put(lastDim, new OrdRange(startOrd, ord - 1));
            }
            startOrd = ord;
            lastDim = components[0];
        }
        if (lastDim != null) {
            this.prefixToOrdRange.put(lastDim, new OrdRange(startOrd, this.valueCount - 1));
        }
    }

    SortedSetDocValues getDocValues() throws IOException {
        return this.topReader.getSortedSetDocValues(this.field);
    }

    OrdRange getOrdRange(String dim) {
        return this.prefixToOrdRange.get(dim);
    }

    String getField() {
        return this.field;
    }

    int getSize() {
        return this.valueCount;
    }

    static final class OrdRange {
        public final int start;
        public final int end;

        public OrdRange(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

