/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.facet.partitions.IntermediateFacetResult;
import org.apache.lucene.facet.partitions.PartitionsFacetResultsHandler;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.Heap;
import org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.util.ResultSortUtils;

public class TopKFacetResultsHandler
extends PartitionsFacetResultsHandler {
    public TopKFacetResultsHandler(TaxonomyReader taxonomyReader, FacetRequest facetRequest, FacetArrays facetArrays) {
        super(taxonomyReader, facetRequest, facetArrays);
    }

    @Override
    public IntermediateFacetResult fetchPartitionResult(int offset) throws IOException {
        TopKFacetResult res = null;
        int ordinal = this.taxonomyReader.getOrdinal(this.facetRequest.categoryPath);
        if (ordinal != -1) {
            double value = 0.0;
            if (this.isSelfPartition(ordinal, this.facetArrays, offset)) {
                int partitionSize = this.facetArrays.arrayLength;
                value = this.facetRequest.getValueOf(this.facetArrays, ordinal % partitionSize);
            }
            FacetResultNode parentResultNode = new FacetResultNode(ordinal, value);
            Heap<FacetResultNode> heap = ResultSortUtils.createSuitableHeap(this.facetRequest);
            int totalFacets = this.heapDescendants(ordinal, heap, parentResultNode, offset);
            res = new TopKFacetResult(this.facetRequest, parentResultNode, totalFacets);
            res.setHeap(heap);
        }
        return res;
    }

    @Override
    public IntermediateFacetResult mergeResults(IntermediateFacetResult ... tmpResults) throws IOException {
        int ordinal = this.taxonomyReader.getOrdinal(this.facetRequest.categoryPath);
        FacetResultNode resNode = new FacetResultNode(ordinal, 0.0);
        int totalFacets = 0;
        Heap<FacetResultNode> heap = null;
        for (IntermediateFacetResult tmpFres : tmpResults) {
            TopKFacetResult fres = (TopKFacetResult)tmpFres;
            totalFacets += fres.getNumValidDescendants();
            resNode.value += fres.getFacetResultNode().value;
            Heap<FacetResultNode> tmpHeap = fres.getHeap();
            if (heap == null) {
                heap = tmpHeap;
                continue;
            }
            for (int i = tmpHeap.size(); i > 0; --i) {
                heap.insertWithOverflow(tmpHeap.pop());
            }
        }
        TopKFacetResult res = new TopKFacetResult(this.facetRequest, resNode, totalFacets);
        res.setHeap(heap);
        return res;
    }

    private int heapDescendants(int ordinal, Heap<FacetResultNode> pq, FacetResultNode parentResultNode, int offset) throws IOException {
        int partitionSize = this.facetArrays.arrayLength;
        int endOffset = offset + partitionSize;
        ParallelTaxonomyArrays childrenArray = this.taxonomyReader.getParallelTaxonomyArrays();
        int[] children = childrenArray.children();
        int[] siblings = childrenArray.siblings();
        FacetResultNode reusable = null;
        int localDepth = 0;
        int depth = this.facetRequest.getDepth();
        int[] ordinalStack = new int[2 + Math.min(Short.MAX_VALUE, depth)];
        int childrenCounter = 0;
        int yc = children[ordinal];
        while (yc >= endOffset) {
            yc = siblings[yc];
        }
        ordinalStack[++localDepth] = yc;
        while (localDepth > 0) {
            int relativeOrdinal;
            double value;
            int tosOrdinal = ordinalStack[localDepth];
            if (tosOrdinal == -1) {
                ordinalStack[--localDepth] = siblings[ordinalStack[localDepth]];
                continue;
            }
            if (tosOrdinal >= offset && (value = this.facetRequest.getValueOf(this.facetArrays, relativeOrdinal = tosOrdinal % partitionSize)) != 0.0 && !Double.isNaN(value)) {
                if (reusable == null) {
                    reusable = new FacetResultNode(tosOrdinal, value);
                } else {
                    reusable.ordinal = tosOrdinal;
                    reusable.value = value;
                    reusable.subResults.clear();
                    reusable.label = null;
                }
                ++childrenCounter;
                reusable = pq.insertWithOverflow(reusable);
            }
            if (localDepth < depth) {
                yc = children[tosOrdinal];
                while (yc >= endOffset) {
                    yc = siblings[yc];
                }
                ordinalStack[++localDepth] = yc;
                continue;
            }
            ordinalStack[++localDepth] = -1;
        }
        return childrenCounter;
    }

    @Override
    public FacetResult renderFacetResult(IntermediateFacetResult tmpResult) {
        TopKFacetResult res = (TopKFacetResult)tmpResult;
        if (res != null) {
            Heap<FacetResultNode> heap = res.getHeap();
            FacetResultNode resNode = res.getFacetResultNode();
            if (resNode.subResults == FacetResultNode.EMPTY_SUB_RESULTS) {
                resNode.subResults = new ArrayList<FacetResultNode>();
            }
            for (int i = heap.size(); i > 0; --i) {
                resNode.subResults.add(0, heap.pop());
            }
        }
        return res;
    }

    @Override
    public FacetResult rearrangeFacetResult(FacetResult facetResult) {
        TopKFacetResult res = (TopKFacetResult)facetResult;
        Heap<FacetResultNode> heap = res.getHeap();
        heap.clear();
        FacetResultNode topFrn = res.getFacetResultNode();
        for (FacetResultNode frn : topFrn.subResults) {
            heap.add(frn);
        }
        int size = heap.size();
        ArrayList<FacetResultNode> subResults = new ArrayList<FacetResultNode>(size);
        for (int i = heap.size(); i > 0; --i) {
            subResults.add(0, heap.pop());
        }
        topFrn.subResults = subResults;
        return res;
    }

    @Override
    public void labelResult(FacetResult facetResult) throws IOException {
        FacetResultNode facetResultNode;
        if (facetResult != null && (facetResultNode = facetResult.getFacetResultNode()) != null) {
            facetResultNode.label = this.taxonomyReader.getPath(facetResultNode.ordinal);
            int num2label = this.facetRequest.getNumLabel();
            for (FacetResultNode frn : facetResultNode.subResults) {
                if (--num2label < 0) break;
                frn.label = this.taxonomyReader.getPath(frn.ordinal);
            }
        }
    }

    private static class TopKFacetResult
    extends FacetResult
    implements IntermediateFacetResult {
        private Heap<FacetResultNode> heap;

        TopKFacetResult(FacetRequest facetRequest, FacetResultNode facetResultNode, int totalFacets) {
            super(facetRequest, facetResultNode, totalFacets);
        }

        public Heap<FacetResultNode> getHeap() {
            return this.heap;
        }

        public void setHeap(Heap<FacetResultNode> heap) {
            this.heap = heap;
        }
    }
}

