/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.writercache.cl2o;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;
import org.apache.lucene.facet.taxonomy.writercache.cl2o.CompactLabelToOrdinal;

public class Cl2oTaxonomyWriterCache
implements TaxonomyWriterCache {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final int initialCapcity;
    private final int numHashArrays;
    private final float loadFactor;
    private volatile CompactLabelToOrdinal cache;

    public Cl2oTaxonomyWriterCache(int initialCapcity, float loadFactor, int numHashArrays) {
        this.cache = new CompactLabelToOrdinal(initialCapcity, loadFactor, numHashArrays);
        this.initialCapcity = initialCapcity;
        this.numHashArrays = numHashArrays;
        this.loadFactor = loadFactor;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache = new CompactLabelToOrdinal(this.initialCapcity, this.loadFactor, this.numHashArrays);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public synchronized void close() {
        this.cache = null;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public int get(CategoryPath categoryPath) {
        this.lock.readLock().lock();
        try {
            int n = this.cache.getOrdinal(categoryPath);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(CategoryPath categoryPath, int ordinal) {
        this.lock.writeLock().lock();
        try {
            this.cache.addLabel(categoryPath, ordinal);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getMemoryUsage() {
        return this.cache == null ? 0 : this.cache.getMemoryUsage();
    }
}

