/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.Heap;
import org.apache.lucene.util.PriorityQueue;

public class ResultSortUtils {
    public static Heap<FacetResultNode> createSuitableHeap(FacetRequest facetRequest) {
        boolean accending;
        int nresults = facetRequest.numResults;
        boolean bl = accending = facetRequest.getSortOrder() == FacetRequest.SortOrder.ASCENDING;
        if (nresults == Integer.MAX_VALUE) {
            return new AllValueHeap(accending);
        }
        if (accending) {
            return new MaxValueHeap(nresults);
        }
        return new MinValueHeap(nresults);
    }

    private static class AllValueHeap
    implements Heap<FacetResultNode> {
        private ArrayList<FacetResultNode> resultNodes = new ArrayList();
        final boolean accending;
        private boolean isReady = false;

        public AllValueHeap(boolean accending) {
            this.accending = accending;
        }

        @Override
        public FacetResultNode insertWithOverflow(FacetResultNode node) {
            this.resultNodes.add(node);
            return null;
        }

        @Override
        public FacetResultNode pop() {
            if (!this.isReady) {
                Collections.sort(this.resultNodes, new Comparator<FacetResultNode>(){

                    @Override
                    public int compare(FacetResultNode o1, FacetResultNode o2) {
                        int value = Double.compare(o1.value, o2.value);
                        if (value == 0) {
                            value = o1.ordinal - o2.ordinal;
                        }
                        if (accending) {
                            value = -value;
                        }
                        return value;
                    }
                });
                this.isReady = true;
            }
            return this.resultNodes.remove(0);
        }

        @Override
        public int size() {
            return this.resultNodes.size();
        }

        @Override
        public FacetResultNode top() {
            if (this.resultNodes.size() > 0) {
                return this.resultNodes.get(0);
            }
            return null;
        }

        @Override
        public FacetResultNode add(FacetResultNode frn) {
            this.resultNodes.add(frn);
            return null;
        }

        @Override
        public void clear() {
            this.resultNodes.clear();
        }
    }

    private static class MaxValueHeap
    extends PriorityQueue<FacetResultNode>
    implements Heap<FacetResultNode> {
        public MaxValueHeap(int size) {
            super(size);
        }

        protected boolean lessThan(FacetResultNode arg0, FacetResultNode arg1) {
            double value0 = arg0.value;
            double value1 = arg1.value;
            int valueCompare = Double.compare(value0, value1);
            if (valueCompare == 0) {
                return arg0.ordinal > arg1.ordinal;
            }
            return valueCompare > 0;
        }
    }

    private static class MinValueHeap
    extends PriorityQueue<FacetResultNode>
    implements Heap<FacetResultNode> {
        public MinValueHeap(int size) {
            super(size);
        }

        protected boolean lessThan(FacetResultNode arg0, FacetResultNode arg1) {
            double value0 = arg0.value;
            double value1 = arg1.value;
            int valueCompare = Double.compare(value0, value1);
            if (valueCompare == 0) {
                return arg0.ordinal < arg1.ordinal;
            }
            return valueCompare < 0;
        }
    }
}

