/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sampling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.partitions.PartitionsFacetResultsHandler;
import org.apache.lucene.facet.sampling.SampleFixer;
import org.apache.lucene.facet.sampling.Sampler;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.StandardFacetsAccumulator;

public class SamplingWrapper
extends StandardFacetsAccumulator {
    private StandardFacetsAccumulator delegee;
    private Sampler sampler;

    public SamplingWrapper(StandardFacetsAccumulator delegee, Sampler sampler) {
        super(delegee.searchParams, delegee.indexReader, delegee.taxonomyReader);
        this.delegee = delegee;
        this.sampler = sampler;
    }

    @Override
    public List<FacetResult> accumulate(ScoredDocIDs docids) throws IOException {
        FacetSearchParams original = this.delegee.searchParams;
        boolean shouldOversample = this.sampler.samplingParams.shouldOverSample();
        if (shouldOversample) {
            this.delegee.searchParams = this.sampler.overSampledSearchParams(original);
        }
        Sampler.SampleResult sampleSet = this.sampler.getSampleSet(docids);
        List<FacetResult> sampleRes = this.delegee.accumulate(sampleSet.docids);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        SampleFixer sampleFixer = this.sampler.samplingParams.getSampleFixer();
        for (FacetResult fres : sampleRes) {
            PartitionsFacetResultsHandler frh = this.createFacetResultsHandler(fres.getFacetRequest());
            if (sampleFixer != null) {
                sampleFixer.fixResult(docids, fres, sampleSet.actualSampleRatio);
                fres = frh.rearrangeFacetResult(fres);
            }
            if (shouldOversample) {
                fres = this.sampler.trimResult(fres);
            }
            if (fres.getFacetResultNode().ordinal == -1) {
                results.add(SamplingWrapper.emptyResult(fres.getFacetResultNode().ordinal, fres.getFacetRequest()));
                continue;
            }
            frh.labelResult(fres);
            results.add(fres);
        }
        if (shouldOversample) {
            this.delegee.searchParams = original;
        }
        return results;
    }

    @Override
    public double getComplementThreshold() {
        return this.delegee.getComplementThreshold();
    }

    @Override
    public void setComplementThreshold(double complementThreshold) {
        this.delegee.setComplementThreshold(complementThreshold);
    }
}

