/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import org.apache.lucene.facet.range.Range;

public final class LongRange
extends Range {
    private final long minIncl;
    private final long maxIncl;
    public final long min;
    public final long max;
    public final boolean minInclusive;
    public final boolean maxInclusive;

    public LongRange(String label, long min, boolean minInclusive, long max, boolean maxInclusive) {
        super(label);
        this.min = min;
        this.max = max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        if (!minInclusive && min != Long.MAX_VALUE) {
            ++min;
        }
        if (!maxInclusive && max != Long.MIN_VALUE) {
            --max;
        }
        this.minIncl = min;
        this.maxIncl = max;
    }

    @Override
    public boolean accept(long value) {
        return value >= this.minIncl && value <= this.maxIncl;
    }
}

