/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.facet.search.DepthOneFacetResultsHandler;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.util.PriorityQueue;

public final class FloatFacetResultsHandler
extends DepthOneFacetResultsHandler {
    private final float[] values;

    public FloatFacetResultsHandler(TaxonomyReader taxonomyReader, FacetRequest facetRequest, FacetArrays facetArrays) {
        super(taxonomyReader, facetRequest, facetArrays);
        this.values = facetArrays.getFloatArray();
    }

    @Override
    protected final double valueOf(int ordinal) {
        return this.values[ordinal];
    }

    @Override
    protected final int addSiblings(int ordinal, int[] siblings, PriorityQueue<FacetResultNode> pq) {
        FacetResultNode top = (FacetResultNode)pq.top();
        int numResults = 0;
        while (ordinal != -1) {
            float value = this.values[ordinal];
            if (value > 0.0f) {
                ++numResults;
                if ((double)value > top.value) {
                    top.value = value;
                    top.ordinal = ordinal;
                    top = (FacetResultNode)pq.updateTop();
                }
            }
            ordinal = siblings[ordinal];
        }
        return numResults;
    }

    @Override
    protected final void addSiblings(int ordinal, int[] siblings, ArrayList<FacetResultNode> nodes) throws IOException {
        while (ordinal != -1) {
            float value = this.values[ordinal];
            if (value > 0.0f) {
                FacetResultNode node = new FacetResultNode(ordinal, value);
                node.label = this.taxonomyReader.getPath(ordinal);
                nodes.add(node);
            }
            ordinal = siblings[ordinal];
        }
    }
}

