/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.IntRollupFacetsAggregator;
import org.apache.lucene.util.IntsRef;

public class CountingFacetsAggregator
extends IntRollupFacetsAggregator {
    private final IntsRef ordinals = new IntsRef(32);

    @Override
    public void aggregate(FacetsCollector.MatchingDocs matchingDocs, CategoryListParams clp, FacetArrays facetArrays) throws IOException {
        CategoryListIterator cli = clp.createCategoryListIterator(0);
        if (!cli.setNextReader(matchingDocs.context)) {
            return;
        }
        int length = matchingDocs.bits.length();
        int[] counts = facetArrays.getIntArray();
        for (int doc = 0; doc < length && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
            cli.getOrdinals(doc, this.ordinals);
            int upto = this.ordinals.offset + this.ordinals.length;
            for (int i = this.ordinals.offset; i < upto; ++i) {
                int n = this.ordinals.ints[i];
                counts[n] = counts[n] + 1;
            }
        }
    }
}

