/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.range.RangeAccumulator;
import org.apache.lucene.facet.range.RangeFacetRequest;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultsHandler;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public class RangeFacetsAccumulatorWrapper
extends FacetsAccumulator {
    private final FacetsAccumulator accumulator;
    private final RangeAccumulator rangeAccumulator;

    public static FacetsAccumulator create(FacetSearchParams fsp, IndexReader indexReader, TaxonomyReader taxoReader) {
        return RangeFacetsAccumulatorWrapper.create(fsp, indexReader, taxoReader, new FacetArrays(taxoReader.getSize()));
    }

    public static FacetsAccumulator create(FacetSearchParams fsp, IndexReader indexReader, TaxonomyReader taxoReader, FacetArrays arrays) {
        ArrayList<FacetRequest> rangeRequests = new ArrayList<FacetRequest>();
        ArrayList<FacetRequest> nonRangeRequests = new ArrayList<FacetRequest>();
        for (FacetRequest fr : fsp.facetRequests) {
            if (fr instanceof RangeFacetRequest) {
                rangeRequests.add(fr);
                continue;
            }
            nonRangeRequests.add(fr);
        }
        if (rangeRequests.isEmpty()) {
            return new FacetsAccumulator(fsp, indexReader, taxoReader, arrays);
        }
        if (nonRangeRequests.isEmpty()) {
            return new RangeAccumulator(fsp, indexReader);
        }
        FacetsAccumulator accumulator = new FacetsAccumulator(new FacetSearchParams(fsp.indexingParams, nonRangeRequests), indexReader, taxoReader, arrays);
        RangeAccumulator rangeAccumulator = new RangeAccumulator(new FacetSearchParams(fsp.indexingParams, rangeRequests), indexReader);
        return new RangeFacetsAccumulatorWrapper(accumulator, rangeAccumulator, fsp);
    }

    private RangeFacetsAccumulatorWrapper(FacetsAccumulator accumulator, RangeAccumulator rangeAccumulator, FacetSearchParams fsp) {
        super(fsp, accumulator.indexReader, accumulator.taxonomyReader);
        this.accumulator = accumulator;
        this.rangeAccumulator = rangeAccumulator;
    }

    @Override
    public FacetsAggregator getAggregator() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected FacetResultsHandler createFacetResultsHandler(FacetRequest fr) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Set<CategoryListParams> getCategoryLists() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean requiresDocScores() {
        return this.accumulator.requiresDocScores();
    }

    @Override
    public List<FacetResult> accumulate(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        List<FacetResult> results = this.accumulator.accumulate(matchingDocs);
        List<FacetResult> rangeResults = this.rangeAccumulator.accumulate(matchingDocs);
        int aUpto = 0;
        int raUpto = 0;
        ArrayList<FacetResult> merged = new ArrayList<FacetResult>();
        for (FacetRequest fr : this.searchParams.facetRequests) {
            if (fr instanceof RangeFacetRequest) {
                merged.add(rangeResults.get(raUpto++));
                continue;
            }
            merged.add(results.get(aUpto++));
        }
        return merged;
    }
}

