/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.associations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.taxonomy.CategoryPath;

public class MultiAssociationsFacetsAggregator
implements FacetsAggregator {
    private final Map<CategoryPath, FacetsAggregator> categoryAggregators;
    private final List<FacetsAggregator> aggregators;

    public MultiAssociationsFacetsAggregator(Map<CategoryPath, FacetsAggregator> aggregators) {
        this.categoryAggregators = aggregators;
        HashMap aggsClasses = new HashMap();
        for (FacetsAggregator fa : aggregators.values()) {
            aggsClasses.put(fa.getClass(), fa);
        }
        this.aggregators = new ArrayList(aggsClasses.values());
    }

    @Override
    public void aggregate(FacetsCollector.MatchingDocs matchingDocs, CategoryListParams clp, FacetArrays facetArrays) throws IOException {
        for (FacetsAggregator fa : this.aggregators) {
            fa.aggregate(matchingDocs, clp, facetArrays);
        }
    }

    @Override
    public void rollupValues(FacetRequest fr, int ordinal, int[] children, int[] siblings, FacetArrays facetArrays) {
        this.categoryAggregators.get(fr.categoryPath).rollupValues(fr, ordinal, children, siblings, facetArrays);
    }

    @Override
    public boolean requiresDocScores() {
        for (FacetsAggregator fa : this.aggregators) {
            if (!fa.requiresDocScores()) continue;
            return true;
        }
        return false;
    }
}

