/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.util.CollectionUtil;

public class FacetResult {
    private final FacetRequest facetRequest;
    private final FacetResultNode rootNode;
    private final int numValidDescendants;

    private static FacetResultNode addIfNotExist(Map<CategoryPath, FacetResultNode> nodes, FacetResultNode node) {
        FacetResultNode n = nodes.get(node.label);
        if (n == null) {
            nodes.put(node.label, node);
            n = node;
        }
        return n;
    }

    public static List<FacetResult> mergeHierarchies(List<FacetResult> results, TaxonomyReader taxoReader, Map<String, FacetArrays> dimArrays) throws IOException {
        HashMap<String, ArrayList<FacetResult>> dims = new HashMap<String, ArrayList<FacetResult>>();
        for (FacetResult fr : results) {
            String dim = fr.getFacetRequest().categoryPath.components[0];
            ArrayList<FacetResult> frs = (ArrayList<FacetResult>)dims.get(dim);
            if (frs == null) {
                frs = new ArrayList<FacetResult>();
                dims.put(dim, frs);
            }
            frs.add(fr);
        }
        ArrayList<FacetResult> res = new ArrayList<FacetResult>();
        for (List frs : dims.values()) {
            FacetResult mergedResult = (FacetResult)frs.get(0);
            if (frs.size() > 1) {
                CollectionUtil.introSort((List)frs, (Comparator)new Comparator<FacetResult>(){

                    @Override
                    public int compare(FacetResult fr1, FacetResult fr2) {
                        return fr1.getFacetRequest().categoryPath.compareTo(fr2.getFacetRequest().categoryPath);
                    }
                });
                HashMap<CategoryPath, FacetResultNode> mergedNodes = new HashMap<CategoryPath, FacetResultNode>();
                FacetArrays arrays = dimArrays != null ? dimArrays.get(((FacetResult)frs.get((int)0)).getFacetRequest().categoryPath.components[0]) : null;
                for (FacetResult fr : frs) {
                    FacetResultNode frn = fr.getFacetResultNode();
                    FacetResultNode merged = (FacetResultNode)mergedNodes.get(frn.label);
                    if (merged == null) {
                        CategoryPath parent = frn.label.subpath(frn.label.length - 1);
                        FacetResultNode childNode = frn;
                        FacetResultNode parentNode = null;
                        while (parent.length > 0 && (parentNode = (FacetResultNode)mergedNodes.get(parent)) == null) {
                            int parentOrd = taxoReader.getOrdinal(parent);
                            double parentValue = arrays != null ? fr.getFacetRequest().getValueOf(arrays, parentOrd) : -1.0;
                            parentNode = new FacetResultNode(parentOrd, parentValue);
                            parentNode.label = parent;
                            parentNode.subResults = new ArrayList<FacetResultNode>();
                            parentNode.subResults.add(childNode);
                            mergedNodes.put(parent, parentNode);
                            childNode = parentNode;
                            parent = parent.subpath(parent.length - 1);
                        }
                        if (parent.length > 0) {
                            if (!(parentNode.subResults instanceof ArrayList)) {
                                parentNode.subResults = new ArrayList<FacetResultNode>(parentNode.subResults);
                            }
                            parentNode.subResults.add(childNode);
                        }
                        mergedNodes.put(frn.label, frn);
                        for (FacetResultNode child : frn.subResults) {
                            FacetResult.addIfNotExist(mergedNodes, child);
                        }
                        continue;
                    }
                    if (!(merged.subResults instanceof ArrayList)) {
                        merged.subResults = new ArrayList<FacetResultNode>(merged.subResults);
                    }
                    for (FacetResultNode sub : frn.subResults) {
                        if (merged.subResults.contains(sub = FacetResult.addIfNotExist(mergedNodes, sub))) continue;
                        merged.subResults.add(sub);
                    }
                }
                CategoryPath min = null;
                for (CategoryPath cp : mergedNodes.keySet()) {
                    if (min != null && cp.compareTo(min) >= 0) continue;
                    min = cp;
                }
                FacetRequest dummy = new FacetRequest(min, ((FacetResult)frs.get((int)0)).getFacetRequest().numResults){

                    @Override
                    public double getValueOf(FacetArrays arrays, int idx) {
                        throw new UnsupportedOperationException("not supported by this request");
                    }

                    @Override
                    public FacetRequest.FacetArraysSource getFacetArraysSource() {
                        throw new UnsupportedOperationException("not supported by this request");
                    }
                };
                mergedResult = new FacetResult(dummy, (FacetResultNode)mergedNodes.get(min), -1);
            }
            res.add(mergedResult);
        }
        return res;
    }

    public FacetResult(FacetRequest facetRequest, FacetResultNode rootNode, int numValidDescendants) {
        this.facetRequest = facetRequest;
        this.rootNode = rootNode;
        this.numValidDescendants = numValidDescendants;
    }

    public final FacetResultNode getFacetResultNode() {
        return this.rootNode;
    }

    public final int getNumValidDescendants() {
        return this.numValidDescendants;
    }

    public final FacetRequest getFacetRequest() {
        return this.facetRequest;
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        String nl = "";
        if (this.facetRequest != null) {
            sb.append(nl).append(prefix).append("Request: ").append(this.facetRequest.toString());
            nl = "\n";
        }
        sb.append(nl).append(prefix).append("Num valid Descendants (up to specified depth): ").append(this.numValidDescendants);
        nl = "\n";
        if (this.rootNode != null) {
            sb.append(nl).append(this.rootNode.toString(prefix + "\t"));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

