/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.codecs.facet42;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.facet.codecs.facet42.Facet42BinaryDocValues;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;

class Facet42DocValuesProducer
extends DocValuesProducer {
    private final Map<Integer, Facet42BinaryDocValues> fields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Facet42DocValuesProducer(SegmentReadState state) throws IOException {
        block6: {
            IndexInput in;
            block5: {
                this.fields = new HashMap<Integer, Facet42BinaryDocValues>();
                String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"fdv");
                in = state.directory.openInput(fileName, state.context);
                boolean success = false;
                try {
                    CodecUtil.checkHeader((DataInput)in, (String)"FacetsDocValues", (int)0, (int)0);
                    int fieldNumber = in.readVInt();
                    while (fieldNumber != -1) {
                        this.fields.put(fieldNumber, new Facet42BinaryDocValues((DataInput)in));
                        fieldNumber = in.readVInt();
                    }
                    success = true;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{in});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{in});
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
    }

    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        throw new UnsupportedOperationException("FacetsDocValues only implements binary");
    }

    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        return this.fields.get(field.number);
    }

    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        throw new UnsupportedOperationException("FacetsDocValues only implements binary");
    }

    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        throw new UnsupportedOperationException("FacetsDocValues only implements binary");
    }

    public void close() throws IOException {
    }
}

