/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.directory.ParallelTaxonomyArrays;
import org.apache.lucene.store.AlreadyClosedException;

public abstract class TaxonomyReader
implements Closeable {
    public static final int ROOT_ORDINAL = 0;
    public static final int INVALID_ORDINAL = -1;
    private volatile boolean closed = false;
    private final AtomicInteger refCount = new AtomicInteger(1);

    public static <T extends TaxonomyReader> T openIfChanged(T oldTaxoReader) throws IOException {
        TaxonomyReader newTaxoReader = oldTaxoReader.doOpenIfChanged();
        assert (newTaxoReader != oldTaxoReader);
        return (T)newTaxoReader;
    }

    protected abstract void doClose() throws IOException;

    protected abstract TaxonomyReader doOpenIfChanged() throws IOException;

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.getRefCount() <= 0) {
            throw new AlreadyClosedException("this TaxonomyReader is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        if (!this.closed) {
            TaxonomyReader taxonomyReader = this;
            synchronized (taxonomyReader) {
                if (!this.closed) {
                    this.decRef();
                    this.closed = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decRef() throws IOException {
        this.ensureOpen();
        int rc = this.refCount.decrementAndGet();
        if (rc == 0) {
            boolean success = false;
            try {
                this.doClose();
                this.closed = true;
                success = true;
            }
            finally {
                if (!success) {
                    this.refCount.incrementAndGet();
                }
            }
        } else if (rc < 0) {
            throw new IllegalStateException("too many decRef calls: refCount is " + rc + " after decrement");
        }
    }

    public abstract ParallelTaxonomyArrays getParallelTaxonomyArrays() throws IOException;

    public abstract Map<String, String> getCommitUserData() throws IOException;

    public abstract int getOrdinal(CategoryPath var1) throws IOException;

    public abstract int getParent(int var1) throws IOException;

    public abstract CategoryPath getPath(int var1) throws IOException;

    public final int getRefCount() {
        return this.refCount.get();
    }

    public abstract int getSize();

    public final void incRef() {
        this.ensureOpen();
        this.refCount.incrementAndGet();
    }
}

