/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.search.DrillDownQuery;
import org.apache.lucene.facet.search.DrillSidewaysQuery;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;

public class DrillSideways {
    protected final IndexSearcher searcher;
    protected final TaxonomyReader taxoReader;

    public DrillSideways(IndexSearcher searcher, TaxonomyReader taxoReader) {
        this.searcher = searcher;
        this.taxoReader = taxoReader;
    }

    public DrillSidewaysResult search(DrillDownQuery query, Collector hitCollector, FacetSearchParams fsp) throws IOException {
        int startClause;
        MatchAllDocsQuery baseQuery;
        Map<String, Integer> drillDownDims = query.getDims();
        if (drillDownDims.isEmpty()) {
            throw new IllegalArgumentException("there must be at least one drill-down");
        }
        BooleanQuery ddq = query.getBooleanQuery();
        BooleanClause[] clauses = ddq.getClauses();
        for (FacetRequest fr : fsp.facetRequests) {
            if (fr.categoryPath.length != 0) continue;
            throw new IllegalArgumentException("all FacetRequests must have CategoryPath with length > 0");
        }
        if (clauses.length == drillDownDims.size()) {
            baseQuery = new MatchAllDocsQuery();
            startClause = 0;
        } else {
            assert (clauses.length == 1 + drillDownDims.size());
            baseQuery = clauses[0].getQuery();
            startClause = 1;
        }
        Term[][] drillDownTerms = new Term[clauses.length - startClause][];
        for (int i = startClause; i < clauses.length; ++i) {
            Query q = clauses[i].getQuery();
            assert (q instanceof ConstantScoreQuery);
            q = ((ConstantScoreQuery)q).getQuery();
            assert (q instanceof TermQuery || q instanceof BooleanQuery);
            if (q instanceof TermQuery) {
                drillDownTerms[i - startClause] = new Term[]{((TermQuery)q).getTerm()};
                continue;
            }
            BooleanQuery q2 = (BooleanQuery)q;
            BooleanClause[] clauses2 = q2.getClauses();
            drillDownTerms[i - startClause] = new Term[clauses2.length];
            for (int j = 0; j < clauses2.length; ++j) {
                assert (clauses2[j].getQuery() instanceof TermQuery);
                drillDownTerms[i - startClause][j] = ((TermQuery)clauses2[j].getQuery()).getTerm();
            }
        }
        FacetsCollector drillDownCollector = FacetsCollector.create(this.getDrillDownAccumulator(fsp));
        Collector[] drillSidewaysCollectors = new FacetsCollector[drillDownDims.size()];
        int idx = 0;
        for (String dim : drillDownDims.keySet()) {
            FacetRequest drillSidewaysRequest = null;
            for (FacetRequest fr : fsp.facetRequests) {
                assert (fr.categoryPath.length > 0);
                if (!fr.categoryPath.components[0].equals(dim)) continue;
                if (drillSidewaysRequest != null) {
                    throw new IllegalArgumentException("multiple FacetRequests for drill-sideways dimension \"" + dim + "\"");
                }
                drillSidewaysRequest = fr;
            }
            if (drillSidewaysRequest == null) {
                throw new IllegalArgumentException("could not find FacetRequest for drill-sideways dimension \"" + dim + "\"");
            }
            drillSidewaysCollectors[idx++] = FacetsCollector.create(this.getDrillSidewaysAccumulator(dim, new FacetSearchParams(fsp.indexingParams, drillSidewaysRequest)));
        }
        DrillSidewaysQuery dsq = new DrillSidewaysQuery((Query)baseQuery, drillDownCollector, drillSidewaysCollectors, drillDownTerms);
        this.searcher.search((Query)dsq, hitCollector);
        List<FacetResult> drillDownResults = drillDownCollector.getFacetResults();
        ArrayList<FacetResult> mergedResults = new ArrayList<FacetResult>();
        for (int i = 0; i < fsp.facetRequests.size(); ++i) {
            FacetRequest fr;
            fr = fsp.facetRequests.get(i);
            assert (fr.categoryPath.length > 0);
            Integer dimIndex = drillDownDims.get(fr.categoryPath.components[0]);
            if (dimIndex == null) {
                mergedResults.add(drillDownResults.get(i));
                continue;
            }
            List<FacetResult> sidewaysResult = drillSidewaysCollectors[dimIndex].getFacetResults();
            assert (sidewaysResult.size() == 1) : "size=" + sidewaysResult.size();
            mergedResults.add(sidewaysResult.get(0));
        }
        return new DrillSidewaysResult(mergedResults, null);
    }

    public DrillSidewaysResult search(DrillDownQuery query, Filter filter, FieldDoc after, int topN, Sort sort, boolean doDocScores, boolean doMaxScore, FacetSearchParams fsp) throws IOException {
        if (filter != null) {
            query = new DrillDownQuery(filter, query);
        }
        if (sort != null) {
            TopFieldCollector hitCollector = TopFieldCollector.create((Sort)sort, (int)Math.min(topN, this.searcher.getIndexReader().maxDoc()), (FieldDoc)after, (boolean)true, (boolean)doDocScores, (boolean)doMaxScore, (boolean)true);
            DrillSidewaysResult r = new DrillSideways(this.searcher, this.taxoReader).search(query, (Collector)hitCollector, fsp);
            r.hits = hitCollector.topDocs();
            return r;
        }
        return this.search((ScoreDoc)after, query, topN, fsp);
    }

    public DrillSidewaysResult search(ScoreDoc after, DrillDownQuery query, int topN, FacetSearchParams fsp) throws IOException {
        TopScoreDocCollector hitCollector = TopScoreDocCollector.create((int)Math.min(topN, this.searcher.getIndexReader().maxDoc()), (ScoreDoc)after, (boolean)true);
        DrillSidewaysResult r = new DrillSideways(this.searcher, this.taxoReader).search(query, (Collector)hitCollector, fsp);
        r.hits = hitCollector.topDocs();
        return r;
    }

    protected FacetsAccumulator getDrillDownAccumulator(FacetSearchParams fsp) {
        return FacetsAccumulator.create(fsp, this.searcher.getIndexReader(), this.taxoReader);
    }

    protected FacetsAccumulator getDrillSidewaysAccumulator(String dim, FacetSearchParams fsp) {
        return FacetsAccumulator.create(fsp, this.searcher.getIndexReader(), this.taxoReader);
    }

    public static class DrillSidewaysResult {
        public final List<FacetResult> facetResults;
        public TopDocs hits;

        DrillSidewaysResult(List<FacetResult> facetResults, TopDocs hits) {
            this.facetResults = facetResults;
            this.hits = hits;
        }
    }
}

