/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.params;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.facet.search.FacetRequest;

public class FacetSearchParams {
    public final FacetIndexingParams indexingParams;
    public final List<FacetRequest> facetRequests;

    public FacetSearchParams(FacetRequest ... facetRequests) {
        this(FacetIndexingParams.DEFAULT, Arrays.asList(facetRequests));
    }

    public FacetSearchParams(List<FacetRequest> facetRequests) {
        this(FacetIndexingParams.DEFAULT, facetRequests);
    }

    public FacetSearchParams(FacetIndexingParams indexingParams, FacetRequest ... facetRequests) {
        this(indexingParams, Arrays.asList(facetRequests));
    }

    public FacetSearchParams(FacetIndexingParams indexingParams, List<FacetRequest> facetRequests) {
        if (facetRequests == null || facetRequests.size() == 0) {
            throw new IllegalArgumentException("at least one FacetRequest must be defined");
        }
        this.facetRequests = facetRequests;
        this.indexingParams = indexingParams;
    }

    public String toString() {
        String INDENT = "  ";
        int NEWLINE = 10;
        StringBuilder sb = new StringBuilder("IndexingParams: ");
        sb.append('\n').append("  ").append(this.indexingParams);
        sb.append('\n').append("FacetRequests:");
        for (FacetRequest facetRequest : this.facetRequests) {
            sb.append('\n').append("  ").append(facetRequest);
        }
        return sb.toString();
    }
}

