/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.encoding.IntDecoder;

public final class VInt8IntDecoder
extends IntDecoder {
    @Override
    public void decode(BytesRef buf, IntsRef values) {
        values.length = 0;
        values.offset = 0;
        if (values.ints.length < buf.length) {
            values.ints = new int[ArrayUtil.oversize((int)buf.length, (int)4)];
        }
        int upto = buf.offset + buf.length;
        int value = 0;
        int offset = buf.offset;
        while (offset < upto) {
            byte b;
            if ((b = buf.bytes[offset++]) >= 0) {
                values.ints[values.length++] = value << 7 | b;
                value = 0;
                continue;
            }
            value = value << 7 | b & 0x7F;
        }
    }

    public String toString() {
        return "VInt8";
    }
}

