/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.encoding.IntDecoder;

public final class SimpleIntDecoder
extends IntDecoder {
    @Override
    public void decode(BytesRef buf, IntsRef values) {
        values.length = 0;
        values.offset = 0;
        int numValues = buf.length / 4;
        if (values.ints.length < numValues) {
            values.ints = new int[ArrayUtil.oversize((int)numValues, (int)4)];
        }
        int offset = buf.offset;
        int upto = buf.offset + buf.length;
        while (offset < upto) {
            values.ints[values.length++] = (buf.bytes[offset++] & 0xFF) << 24 | (buf.bytes[offset++] & 0xFF) << 16 | (buf.bytes[offset++] & 0xFF) << 8 | buf.bytes[offset++] & 0xFF;
        }
    }

    public String toString() {
        return "Simple";
    }
}

