/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.encoding.FourFlagsIntDecoder;

public class NOnesIntDecoder
extends FourFlagsIntDecoder {
    private final int n;
    private final IntsRef internalBuffer;

    public NOnesIntDecoder(int n) {
        this.n = n;
        this.internalBuffer = new IntsRef(100);
    }

    @Override
    public void decode(BytesRef buf, IntsRef values) {
        values.length = 0;
        values.offset = 0;
        this.internalBuffer.length = 0;
        super.decode(buf, this.internalBuffer);
        if (values.ints.length < this.internalBuffer.length) {
            values.grow(this.internalBuffer.length * this.n / 2);
        }
        for (int i = 0; i < this.internalBuffer.length; ++i) {
            int decode = this.internalBuffer.ints[i];
            if (decode == 1) {
                if (values.length == values.ints.length) {
                    values.grow(values.length + 10);
                }
                values.ints[values.length++] = 1;
                continue;
            }
            if (decode == 2) {
                if (values.length + this.n >= values.ints.length) {
                    values.grow(values.length + this.n);
                }
                for (int j = 0; j < this.n; ++j) {
                    values.ints[values.length++] = 1;
                }
                continue;
            }
            if (values.length == values.ints.length) {
                values.grow(values.length + 10);
            }
            values.ints[values.length++] = decode - 1;
        }
    }

    @Override
    public String toString() {
        return "NOnes(" + this.n + ") (" + super.toString() + ")";
    }
}

