/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.encoding.ChunksIntEncoder;
import org.apache.lucene.util.encoding.FourFlagsIntDecoder;
import org.apache.lucene.util.encoding.IntDecoder;

public class FourFlagsIntEncoder
extends ChunksIntEncoder {
    private static final byte[][] ENCODE_TABLE = new byte[][]{{0, 0, 0, 0}, {1, 4, 16, 64}, {2, 8, 32, -128}, {3, 12, 48, -64}};

    public FourFlagsIntEncoder() {
        super(4);
    }

    @Override
    public void encode(IntsRef values, BytesRef buf) {
        buf.length = 0;
        buf.offset = 0;
        int upto = values.offset + values.length;
        for (int i = values.offset; i < upto; ++i) {
            int value = values.ints[i];
            if (value <= 3) {
                this.indicator |= ENCODE_TABLE[value][this.ordinal];
            } else {
                this.encodeQueue.ints[this.encodeQueue.length++] = value - 4;
            }
            this.ordinal = (byte)(this.ordinal + 1);
            if (this.ordinal != 4) continue;
            this.encodeChunk(buf);
        }
        if (this.ordinal != 0) {
            this.encodeChunk(buf);
        }
    }

    @Override
    public IntDecoder createMatchingDecoder() {
        return new FourFlagsIntDecoder();
    }

    public String toString() {
        return "FourFlags(VInt)";
    }
}

