/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.encoding.DGapIntDecoder;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.IntEncoder;
import org.apache.lucene.util.encoding.IntEncoderFilter;

public final class DGapIntEncoder
extends IntEncoderFilter {
    public DGapIntEncoder(IntEncoder encoder) {
        super(encoder);
    }

    @Override
    public void encode(IntsRef values, BytesRef buf) {
        int prev = 0;
        int upto = values.offset + values.length;
        int i = values.offset;
        while (i < upto) {
            int tmp = values.ints[i];
            int n = i++;
            values.ints[n] = values.ints[n] - prev;
            prev = tmp;
        }
        this.encoder.encode(values, buf);
    }

    @Override
    public IntDecoder createMatchingDecoder() {
        return new DGapIntDecoder(this.encoder.createMatchingDecoder());
    }

    public String toString() {
        return "DGap(" + this.encoder.toString() + ")";
    }
}

