/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.collections;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUHashMap<K, V>
extends LinkedHashMap<K, V> {
    private int maxSize;

    public LRUHashMap(int maxSize) {
        super(16, 0.75f, true);
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxSize;
    }

    @Override
    public LRUHashMap<K, V> clone() {
        return (LRUHashMap)super.clone();
    }
}

