/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.collections;

import java.util.Arrays;
import org.apache.lucene.util.collections.IntIterator;

public class IntHashSet {
    private static int defaultCapacity = 16;
    int[] baseHash;
    private int capacity = 16;
    private int firstEmpty;
    private int hashFactor;
    int[] keys;
    int[] next;
    private int prev;
    private int size;

    public IntHashSet() {
        this(defaultCapacity);
    }

    public IntHashSet(int capacity) {
        while (this.capacity < capacity) {
            this.capacity <<= 1;
        }
        int arrayLength = this.capacity + 1;
        this.keys = new int[arrayLength];
        this.next = new int[arrayLength];
        int baseHashSize = this.capacity << 1;
        this.baseHash = new int[baseHashSize];
        this.hashFactor = baseHashSize - 1;
        this.size = 0;
        this.clear();
    }

    private void prvt_add(int key) {
        int hashIndex = this.calcBaseHashIndex(key);
        int objectIndex = this.firstEmpty;
        this.firstEmpty = this.next[this.firstEmpty];
        this.keys[objectIndex] = key;
        this.next[objectIndex] = this.baseHash[hashIndex];
        this.baseHash[hashIndex] = objectIndex;
        ++this.size;
    }

    protected int calcBaseHashIndex(int key) {
        return key & this.hashFactor;
    }

    public void clear() {
        Arrays.fill(this.baseHash, 0);
        this.size = 0;
        this.firstEmpty = 1;
        int i = 1;
        while (i < this.capacity) {
            this.next[i++] = i;
        }
        this.next[this.capacity] = 0;
    }

    public boolean contains(int value) {
        return this.find(value) != 0;
    }

    protected int find(int key) {
        int baseHashIndex = this.calcBaseHashIndex(key);
        int localIndex = this.baseHash[baseHashIndex];
        while (localIndex != 0) {
            if (this.keys[localIndex] == key) {
                return localIndex;
            }
            localIndex = this.next[localIndex];
        }
        return 0;
    }

    private int findForRemove(int key, int baseHashIndex) {
        this.prev = 0;
        int index = this.baseHash[baseHashIndex];
        while (index != 0) {
            if (this.keys[index] == key) {
                return index;
            }
            this.prev = index;
            index = this.next[index];
        }
        this.prev = 0;
        return 0;
    }

    protected void grow() {
        IntHashSet that = new IntHashSet(this.capacity * 2);
        IndexIterator iterator = new IndexIterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            that.prvt_add(this.keys[index]);
        }
        this.capacity = that.capacity;
        this.size = that.size;
        this.firstEmpty = that.firstEmpty;
        this.keys = that.keys;
        this.next = that.next;
        this.baseHash = that.baseHash;
        this.hashFactor = that.hashFactor;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public IntIterator iterator() {
        return new KeyIterator();
    }

    private String getBaseHashAsString() {
        return Arrays.toString(this.baseHash);
    }

    public boolean add(int value) {
        int index = this.find(value);
        if (index != 0) {
            return true;
        }
        if (this.size == this.capacity) {
            this.grow();
        }
        this.prvt_add(value);
        return true;
    }

    public boolean remove(int value) {
        int baseHashIndex = this.calcBaseHashIndex(value);
        int index = this.findForRemove(value, baseHashIndex);
        if (index != 0) {
            if (this.prev == 0) {
                this.baseHash[baseHashIndex] = this.next[index];
            }
            this.next[this.prev] = this.next[index];
            this.next[index] = this.firstEmpty;
            this.firstEmpty = index;
            --this.size;
            return true;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public int[] toArray() {
        int j = -1;
        int[] array = new int[this.size];
        IntIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            array[++j] = iterator.next();
        }
        return array;
    }

    public int[] toArray(int[] a) {
        int j = 0;
        if (a.length < this.size) {
            a = new int[this.size];
        }
        IntIterator iterator = this.iterator();
        while (j < a.length && iterator.hasNext()) {
            a[j] = iterator.next();
            ++j;
        }
        return a;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        IntIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    public String toHashString() {
        String string = "\n";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.baseHash.length; ++i) {
            StringBuffer sb2 = new StringBuffer();
            boolean shouldAppend = false;
            sb2.append(i + ".\t");
            int index = this.baseHash[i];
            while (index != 0) {
                sb2.append(" -> " + this.keys[index] + "@" + index);
                shouldAppend = true;
                index = this.next[index];
            }
            if (!shouldAppend) continue;
            sb.append(sb2);
            sb.append(string);
        }
        return sb.toString();
    }

    private final class KeyIterator
    implements IntIterator {
        private IntIterator iterator;

        KeyIterator() {
            this.iterator = new IndexIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public int next() {
            return IntHashSet.this.keys[this.iterator.next()];
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class IndexIterator
    implements IntIterator {
        private int baseHashIndex = 0;
        private int index = 0;
        private int lastIndex = 0;

        public IndexIterator() {
            while (this.baseHashIndex < IntHashSet.this.baseHash.length) {
                this.index = IntHashSet.this.baseHash[this.baseHashIndex];
                if (this.index != 0) break;
                ++this.baseHashIndex;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index != 0;
        }

        @Override
        public int next() {
            this.lastIndex = this.index;
            this.index = IntHashSet.this.next[this.index];
            while (this.index == 0 && ++this.baseHashIndex < IntHashSet.this.baseHash.length) {
                this.index = IntHashSet.this.baseHash[this.baseHashIndex];
            }
            return this.lastIndex;
        }

        @Override
        public void remove() {
            IntHashSet.this.remove(IntHashSet.this.keys[this.lastIndex]);
        }
    }
}

