/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.sampling;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.aggregator.Aggregator;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.search.results.MutableFacetResultNode;
import org.apache.lucene.facet.search.sampling.SampleFixer;
import org.apache.lucene.facet.search.sampling.SamplingParams;
import org.apache.lucene.facet.search.sampling.TakmiSampleFixer;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public abstract class Sampler {
    protected final SamplingParams samplingParams;

    public Sampler() {
        this(new SamplingParams());
    }

    public Sampler(SamplingParams params) throws IllegalArgumentException {
        if (!params.validate()) {
            throw new IllegalArgumentException("The provided SamplingParams are not valid!!");
        }
        this.samplingParams = params;
    }

    public boolean shouldSample(ScoredDocIDs docIds) {
        return docIds.size() > this.samplingParams.getSamplingThreshold();
    }

    public SampleResult getSampleSet(ScoredDocIDs docids) throws IOException {
        if (!this.shouldSample(docids)) {
            return new SampleResult(docids, 1.0);
        }
        int actualSize = docids.size();
        int sampleSetSize = (int)((double)actualSize * this.samplingParams.getSampleRatio());
        sampleSetSize = Math.max(sampleSetSize, this.samplingParams.getMinSampleSize());
        sampleSetSize = Math.min(sampleSetSize, this.samplingParams.getMaxSampleSize());
        return this.createSample(docids, actualSize, sampleSetSize);
    }

    protected abstract SampleResult createSample(ScoredDocIDs var1, int var2, int var3) throws IOException;

    public SampleFixer getSampleFixer(IndexReader indexReader, TaxonomyReader taxonomyReader, FacetSearchParams searchParams) {
        return new TakmiSampleFixer(indexReader, taxonomyReader, searchParams);
    }

    public final SamplingParams getSamplingParams() {
        return this.samplingParams;
    }

    public FacetResult trimResult(FacetResult facetResult) throws IllegalArgumentException {
        double overSampleFactor = this.getSamplingParams().getOversampleFactor();
        if (overSampleFactor <= 1.0) {
            return facetResult;
        }
        OverSampledFacetRequest sampledFreq = null;
        try {
            sampledFreq = (OverSampledFacetRequest)facetResult.getFacetRequest();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("It is only valid to call this method with result obtained for a facet request created through sampler.overSamlpingSearchParams()", e);
        }
        FacetRequest origFrq = sampledFreq.orig;
        MutableFacetResultNode trimmedRootNode = MutableFacetResultNode.toImpl(facetResult.getFacetResultNode());
        trimmedRootNode.trimSubResults(origFrq.getNumResults());
        return new FacetResult(origFrq, trimmedRootNode, facetResult.getNumValidDescendants());
    }

    public FacetSearchParams overSampledSearchParams(FacetSearchParams original) {
        FacetSearchParams res = original;
        double overSampleFactor = this.getSamplingParams().getOversampleFactor();
        if (overSampleFactor > 1.0) {
            ArrayList<FacetRequest> facetRequests = new ArrayList<FacetRequest>();
            for (FacetRequest frq : original.getFacetRequests()) {
                int overSampledNumResults = (int)Math.ceil((double)frq.getNumResults() * overSampleFactor);
                facetRequests.add(new OverSampledFacetRequest(frq, overSampledNumResults));
            }
            res = new FacetSearchParams(facetRequests, original.getFacetIndexingParams());
        }
        return res;
    }

    private static class OverSampledFacetRequest
    extends FacetRequest {
        final FacetRequest orig;

        public OverSampledFacetRequest(FacetRequest orig, int num) {
            super(orig.getCategoryPath(), num);
            this.orig = orig;
            this.setDepth(orig.getDepth());
            this.setNumLabel(orig.getNumLabel());
            this.setResultMode(orig.getResultMode());
            this.setSortBy(orig.getSortBy());
            this.setSortOrder(orig.getSortOrder());
        }

        @Override
        public CategoryListIterator createCategoryListIterator(TaxonomyReader taxo, FacetSearchParams sParams, int partition) throws IOException {
            return this.orig.createCategoryListIterator(taxo, sParams, partition);
        }

        @Override
        public Aggregator createAggregator(boolean useComplements, FacetArrays arrays, TaxonomyReader taxonomy) throws IOException {
            return this.orig.createAggregator(useComplements, arrays, taxonomy);
        }

        @Override
        public double getValueOf(FacetArrays arrays, int idx) {
            return this.orig.getValueOf(arrays, idx);
        }

        @Override
        public boolean requireDocumentScore() {
            return this.orig.requireDocumentScore();
        }

        @Override
        public boolean supportsComplements() {
            return this.orig.supportsComplements();
        }
    }

    public static final class SampleResult {
        public final ScoredDocIDs docids;
        public final double actualSampleRatio;

        protected SampleResult(ScoredDocIDs docids, double actualSampleRatio) {
            this.docids = docids;
            this.actualSampleRatio = actualSampleRatio;
        }
    }
}

