/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.cache;

import java.io.IOException;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.IntsRef;

public class CategoryListData {
    private volatile transient int[][][] docPartitionCategories;

    protected CategoryListData() {
    }

    CategoryListData(IndexReader reader, TaxonomyReader taxo, FacetIndexingParams iparams, CategoryListParams clp) throws IOException {
        int[][][] dpf = new int[reader.maxDoc()][][];
        int numPartitions = (int)Math.ceil((double)taxo.getSize() / (double)iparams.getPartitionSize());
        IntsRef ordinals = new IntsRef(32);
        for (int part = 0; part < numPartitions; ++part) {
            for (AtomicReaderContext context : reader.leaves()) {
                CategoryListIterator cli = clp.createCategoryListIterator(part);
                if (!cli.setNextReader(context)) continue;
                int maxDoc = context.reader().maxDoc();
                for (int i = 0; i < maxDoc; ++i) {
                    cli.getOrdinals(i, ordinals);
                    if (ordinals.length <= 0) continue;
                    int doc = i + context.docBase;
                    if (dpf[doc] == null) {
                        dpf[doc] = new int[numPartitions][];
                    }
                    if (dpf[doc][part] == null) {
                        dpf[doc][part] = new int[ordinals.length];
                    }
                    for (int j = 0; j < ordinals.length; ++j) {
                        dpf[doc][part][j] = ordinals.ints[j];
                    }
                }
            }
        }
        this.docPartitionCategories = dpf;
    }

    public CategoryListIterator iterator(int partition) throws IOException {
        return new RAMCategoryListIterator(partition, this.docPartitionCategories);
    }

    private static class RAMCategoryListIterator
    implements CategoryListIterator {
        private int docBase;
        private final int part;
        private final int[][][] dpc;

        RAMCategoryListIterator(int part, int[][][] docPartitionCategories) {
            this.part = part;
            this.dpc = docPartitionCategories;
        }

        @Override
        public boolean setNextReader(AtomicReaderContext context) throws IOException {
            this.docBase = context.docBase;
            return this.dpc != null && this.dpc.length > this.part;
        }

        @Override
        public void getOrdinals(int docID, IntsRef ints) throws IOException {
            ints.length = 0;
            if (this.dpc.length > (docID += this.docBase) && this.dpc[docID] != null && this.dpc[docID][this.part] != null) {
                if (ints.ints.length < this.dpc[docID][this.part].length) {
                    ints.grow(this.dpc[docID][this.part].length);
                }
                ints.length = 0;
                for (int i = 0; i < this.dpc[docID][this.part].length; ++i) {
                    ints.ints[ints.length++] = this.dpc[docID][this.part][i];
                }
            }
        }
    }
}

