/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.aggregator;

import java.io.IOException;
import org.apache.lucene.facet.search.aggregator.CountingAggregator;
import org.apache.lucene.util.IntsRef;

public class ComplementCountingAggregator
extends CountingAggregator {
    public ComplementCountingAggregator(int[] counterArray) {
        super(counterArray);
    }

    @Override
    public void aggregate(int docID, float score, IntsRef ordinals) throws IOException {
        for (int i = 0; i < ordinals.length; ++i) {
            int ord = ordinals.ints[i];
            assert (this.counterArray[ord] != 0) : "complement aggregation: count is about to become negative for ordinal " + ord;
            int n = ord;
            this.counterArray[n] = this.counterArray[n] - 1;
        }
    }
}

