/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.search.FacetResultsHandler;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.search.sampling.Sampler;

public class SamplingWrapper
extends FacetsAccumulator {
    private FacetsAccumulator delegee;
    private Sampler sampler;

    public SamplingWrapper(FacetsAccumulator delegee, Sampler sampler) {
        super(delegee.searchParams, delegee.indexReader, delegee.taxonomyReader);
        this.delegee = delegee;
        this.sampler = sampler;
    }

    @Override
    public List<FacetResult> accumulate(ScoredDocIDs docids) throws IOException {
        boolean origAllowLabeling = this.isAllowLabeling();
        this.setAllowLabeling(false);
        FacetSearchParams original = this.delegee.searchParams;
        this.delegee.searchParams = this.sampler.overSampledSearchParams(original);
        Sampler.SampleResult sampleSet = this.sampler.getSampleSet(docids);
        List<FacetResult> sampleRes = this.delegee.accumulate(sampleSet.docids);
        this.setAllowLabeling(origAllowLabeling);
        ArrayList<FacetResult> fixedRes = new ArrayList<FacetResult>();
        for (FacetResult fres : sampleRes) {
            FacetResultsHandler frh = fres.getFacetRequest().createFacetResultsHandler(this.taxonomyReader);
            this.sampler.getSampleFixer(this.indexReader, this.taxonomyReader, this.searchParams).fixResult(docids, fres);
            fres = frh.rearrangeFacetResult(fres);
            fres = this.sampler.trimResult(fres);
            if (this.isAllowLabeling()) {
                frh.labelResult(fres);
            }
            fixedRes.add(fres);
        }
        this.delegee.searchParams = original;
        return fixedRes;
    }

    @Override
    public double getComplementThreshold() {
        return this.delegee.getComplementThreshold();
    }

    @Override
    public void setComplementThreshold(double complementThreshold) {
        this.delegee.setComplementThreshold(complementThreshold);
    }

    @Override
    protected boolean isAllowLabeling() {
        return this.delegee.isAllowLabeling();
    }

    @Override
    protected void setAllowLabeling(boolean allowLabeling) {
        this.delegee.setAllowLabeling(allowLabeling);
    }
}

