/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.search.results.IntermediateFacetResult;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

public abstract class FacetResultsHandler {
    protected final TaxonomyReader taxonomyReader;
    protected final FacetRequest facetRequest;

    public FacetResultsHandler(TaxonomyReader taxonomyReader, FacetRequest facetRequest) {
        this.taxonomyReader = taxonomyReader;
        this.facetRequest = facetRequest;
    }

    public abstract IntermediateFacetResult fetchPartitionResult(FacetArrays var1, int var2) throws IOException;

    public abstract IntermediateFacetResult mergeResults(IntermediateFacetResult ... var1) throws IOException, ClassCastException, IllegalArgumentException;

    public abstract FacetResult renderFacetResult(IntermediateFacetResult var1) throws IOException;

    public abstract FacetResult rearrangeFacetResult(FacetResult var1);

    public abstract void labelResult(FacetResult var1) throws IOException;

    public final TaxonomyReader getTaxonomyReader() {
        return this.taxonomyReader;
    }

    public final FacetRequest getFacetRequest() {
        return this.facetRequest;
    }

    protected boolean isSelfPartition(int ordinal, FacetArrays facetArrays, int offset) {
        int partitionSize = facetArrays.arrayLength;
        return ordinal / partitionSize == offset / partitionSize;
    }
}

