/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index.params;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;

public class PerDimensionIndexingParams
extends FacetIndexingParams {
    private final Map<String, CategoryListParams> clParamsMap = new HashMap<String, CategoryListParams>();

    public PerDimensionIndexingParams(Map<CategoryPath, CategoryListParams> paramsMap) {
        this(paramsMap, DEFAULT_CATEGORY_LIST_PARAMS);
    }

    public PerDimensionIndexingParams(Map<CategoryPath, CategoryListParams> paramsMap, CategoryListParams categoryListParams) {
        super(categoryListParams);
        for (Map.Entry<CategoryPath, CategoryListParams> e : paramsMap.entrySet()) {
            this.clParamsMap.put(e.getKey().components[0], e.getValue());
        }
    }

    @Override
    public List<CategoryListParams> getAllCategoryListParams() {
        ArrayList<CategoryListParams> vals = new ArrayList<CategoryListParams>(this.clParamsMap.values());
        vals.add(this.clParams);
        return vals;
    }

    @Override
    public CategoryListParams getCategoryListParams(CategoryPath category) {
        CategoryListParams clParams;
        if (category != null && (clParams = this.clParamsMap.get(category.components[0])) != null) {
            return clParams;
        }
        return this.clParams;
    }
}

