/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index.params;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.index.categorypolicy.OrdinalPolicy;
import org.apache.lucene.facet.index.categorypolicy.PathPolicy;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;

public class FacetIndexingParams {
    protected static final CategoryListParams DEFAULT_CATEGORY_LIST_PARAMS = new CategoryListParams();
    public static final FacetIndexingParams ALL_PARENTS = new FacetIndexingParams();
    public static final char DEFAULT_FACET_DELIM_CHAR = '\uf749';
    private final OrdinalPolicy ordinalPolicy = OrdinalPolicy.ALL_PARENTS;
    private final PathPolicy pathPolicy = PathPolicy.ALL_CATEGORIES;
    private final int partitionSize = Integer.MAX_VALUE;
    protected final CategoryListParams clParams;

    public FacetIndexingParams() {
        this(DEFAULT_CATEGORY_LIST_PARAMS);
    }

    public FacetIndexingParams(CategoryListParams categoryListParams) {
        this.clParams = categoryListParams;
    }

    public CategoryListParams getCategoryListParams(CategoryPath category) {
        return this.clParams;
    }

    public int drillDownTermText(CategoryPath path, char[] buffer) {
        return path.copyFullPath(buffer, 0, this.getFacetDelimChar());
    }

    public int getPartitionSize() {
        return Integer.MAX_VALUE;
    }

    public List<CategoryListParams> getAllCategoryListParams() {
        return Collections.singletonList(this.clParams);
    }

    public OrdinalPolicy getOrdinalPolicy() {
        return this.ordinalPolicy;
    }

    public PathPolicy getPathPolicy() {
        return this.pathPolicy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clParams == null ? 0 : this.clParams.hashCode());
        result = 31 * result + (this.ordinalPolicy == null ? 0 : this.ordinalPolicy.hashCode());
        result = 31 * result + Integer.MAX_VALUE;
        result = 31 * result + (this.pathPolicy == null ? 0 : this.pathPolicy.hashCode());
        for (CategoryListParams clp : this.getAllCategoryListParams()) {
            result ^= clp.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetIndexingParams)) {
            return false;
        }
        FacetIndexingParams other = (FacetIndexingParams)obj;
        if (this.clParams == null ? other.clParams != null : !this.clParams.equals(other.clParams)) {
            return false;
        }
        if (this.ordinalPolicy == null ? other.ordinalPolicy != null : !this.ordinalPolicy.equals(other.ordinalPolicy)) {
            return false;
        }
        if (Integer.MAX_VALUE != other.partitionSize) {
            return false;
        }
        if (this.pathPolicy == null ? other.pathPolicy != null : !this.pathPolicy.equals(other.pathPolicy)) {
            return false;
        }
        List<CategoryListParams> cLs = this.getAllCategoryListParams();
        List<CategoryListParams> otherCLs = other.getAllCategoryListParams();
        return ((Object)cLs).equals(otherCLs);
    }

    public char getFacetDelimChar() {
        return '\uf749';
    }
}

