/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index.params;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.search.PayloadCategoryListIteraor;
import org.apache.lucene.facet.util.PartitionsUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.encoding.DGapIntEncoder;
import org.apache.lucene.util.encoding.IntEncoder;
import org.apache.lucene.util.encoding.SortingIntEncoder;
import org.apache.lucene.util.encoding.UniqueValuesIntEncoder;
import org.apache.lucene.util.encoding.VInt8IntEncoder;

public class CategoryListParams
implements Serializable {
    public static final Term DEFAULT_TERM = new Term("$facets", "$fulltree$");
    private final Term term;
    private final int hashCode;

    public CategoryListParams() {
        this(DEFAULT_TERM);
    }

    public CategoryListParams(Term term) {
        this.term = term;
        this.hashCode = term.hashCode();
    }

    public final Term getTerm() {
        return this.term;
    }

    public IntEncoder createEncoder() {
        return new SortingIntEncoder(new UniqueValuesIntEncoder(new DGapIntEncoder(new VInt8IntEncoder())));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoryListParams)) {
            return false;
        }
        CategoryListParams other = (CategoryListParams)o;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        return this.term.equals((Object)other.term);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public CategoryListIterator createCategoryListIterator(int partition) throws IOException {
        String categoryListTermStr = PartitionsUtils.partitionName(this, partition);
        Term payloadTerm = new Term(this.term.field(), categoryListTermStr);
        return new PayloadCategoryListIteraor(payloadTerm, this.createEncoder().createMatchingDecoder());
    }
}

