/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.IntEncoder;

public class OrdinalMappingAtomicReader
extends FilterAtomicReader {
    private final int[] ordinalMap;
    private final Map<String, Map<BytesRef, CategoryListParams>> termMap = new HashMap<String, Map<BytesRef, CategoryListParams>>(1);

    public OrdinalMappingAtomicReader(AtomicReader in, int[] ordinalMap) {
        this(in, ordinalMap, FacetIndexingParams.ALL_PARENTS);
    }

    public OrdinalMappingAtomicReader(AtomicReader in, int[] ordinalMap, FacetIndexingParams indexingParams) {
        super(in);
        this.ordinalMap = ordinalMap;
        for (CategoryListParams params : indexingParams.getAllCategoryListParams()) {
            Term term = params.getTerm();
            Map<BytesRef, CategoryListParams> fieldMap = this.termMap.get(term.field());
            if (fieldMap == null) {
                fieldMap = new HashMap<BytesRef, CategoryListParams>(1);
                this.termMap.put(term.field(), fieldMap);
            }
            fieldMap.put(term.bytes(), params);
        }
    }

    public Fields getTermVectors(int docID) throws IOException {
        Fields fields = super.getTermVectors(docID);
        if (fields == null) {
            return null;
        }
        return new OrdinalMappingFields(fields);
    }

    public Fields fields() throws IOException {
        Fields fields = super.fields();
        if (fields == null) {
            return null;
        }
        return new OrdinalMappingFields(fields);
    }

    private class OrdinalMappingDocsAndPositionsEnum
    extends FilterAtomicReader.FilterDocsAndPositionsEnum {
        private final IntEncoder encoder;
        private final IntDecoder decoder;
        private final IntsRef ordinals;
        private final BytesRef payloadOut;

        public OrdinalMappingDocsAndPositionsEnum(DocsAndPositionsEnum in, CategoryListParams params) {
            super(in);
            this.ordinals = new IntsRef(32);
            this.payloadOut = new BytesRef();
            this.encoder = params.createEncoder();
            this.decoder = this.encoder.createMatchingDecoder();
        }

        public BytesRef getPayload() throws IOException {
            BytesRef payload = super.getPayload();
            if (payload == null) {
                return payload;
            }
            this.decoder.decode(payload, this.ordinals);
            for (int i = 0; i < this.ordinals.length; ++i) {
                this.ordinals.ints[i] = OrdinalMappingAtomicReader.this.ordinalMap[this.ordinals.ints[i]];
            }
            this.encoder.encode(this.ordinals, this.payloadOut);
            return this.payloadOut;
        }
    }

    private class OrdinalMappingTermsEnum
    extends FilterAtomicReader.FilterTermsEnum {
        private final Map<BytesRef, CategoryListParams> termsMap;

        public OrdinalMappingTermsEnum(TermsEnum in, Map<BytesRef, CategoryListParams> termsMap) {
            super(in);
            this.termsMap = termsMap;
        }

        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            DocsAndPositionsEnum inner = super.docsAndPositions(liveDocs, reuse, flags);
            if (inner == null) {
                return inner;
            }
            CategoryListParams params = this.termsMap.get(this.term());
            if (params == null) {
                return inner;
            }
            return new OrdinalMappingDocsAndPositionsEnum(inner, params);
        }
    }

    private class OrdinalMappingTerms
    extends FilterAtomicReader.FilterTerms {
        private final Map<BytesRef, CategoryListParams> termsMap;

        public OrdinalMappingTerms(Terms in, Map<BytesRef, CategoryListParams> termsMap) {
            super(in);
            this.termsMap = termsMap;
        }

        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            return new OrdinalMappingTermsEnum(super.iterator(reuse), this.termsMap);
        }
    }

    private class OrdinalMappingFields
    extends FilterAtomicReader.FilterFields {
        public OrdinalMappingFields(Fields in) {
            super(in);
        }

        public Terms terms(String field) throws IOException {
            Terms terms = super.terms(field);
            if (terms == null) {
                return terms;
            }
            Map termsMap = (Map)OrdinalMappingAtomicReader.this.termMap.get(field);
            if (termsMap == null) {
                return terms;
            }
            return new OrdinalMappingTerms(terms, termsMap);
        }
    }
}

