/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.index.CountingListBuilder;
import org.apache.lucene.facet.index.DrillDownStream;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public class FacetFields {
    private static final FieldType COUNTING_LIST_PAYLOAD_TYPE = new FieldType();
    private static final FieldType DRILL_DOWN_TYPE;
    protected final TaxonomyWriter taxonomyWriter;
    protected final FacetIndexingParams indexingParams;

    public FacetFields(TaxonomyWriter taxonomyWriter) {
        this(taxonomyWriter, FacetIndexingParams.ALL_PARENTS);
    }

    public FacetFields(TaxonomyWriter taxonomyWriter, FacetIndexingParams params) {
        this.taxonomyWriter = taxonomyWriter;
        this.indexingParams = params;
    }

    protected Map<CategoryListParams, Iterable<CategoryPath>> createCategoryListMapping(Iterable<CategoryPath> categories) {
        if (this.indexingParams.getAllCategoryListParams().size() == 1) {
            return Collections.singletonMap(this.indexingParams.getCategoryListParams(null), categories);
        }
        HashMap<CategoryListParams, Iterable<CategoryPath>> categoryLists = new HashMap<CategoryListParams, Iterable<CategoryPath>>();
        for (CategoryPath cp : categories) {
            CategoryListParams clp = this.indexingParams.getCategoryListParams(cp);
            ArrayList<CategoryPath> list = (ArrayList<CategoryPath>)categoryLists.get(clp);
            if (list == null) {
                list = new ArrayList<CategoryPath>();
                categoryLists.put(clp, list);
            }
            list.add(cp);
        }
        return categoryLists;
    }

    protected Map<String, BytesRef> getCategoryListData(CategoryListParams categoryListParams, IntsRef ordinals, Iterable<CategoryPath> categories) throws IOException {
        return new CountingListBuilder(categoryListParams, this.indexingParams, this.taxonomyWriter).build(ordinals, categories);
    }

    protected DrillDownStream getDrillDownStream(Iterable<CategoryPath> categories) {
        return new DrillDownStream(categories, this.indexingParams);
    }

    protected FieldType fieldType() {
        return DRILL_DOWN_TYPE;
    }

    public void addFields(Document doc, Iterable<CategoryPath> categories) throws IOException {
        if (categories == null) {
            throw new IllegalArgumentException("categories should not be null");
        }
        Map<CategoryListParams, Iterable<CategoryPath>> categoryLists = this.createCategoryListMapping(categories);
        IntsRef ordinals = new IntsRef(32);
        for (Map.Entry<CategoryListParams, Iterable<CategoryPath>> e : categoryLists.entrySet()) {
            CategoryListParams clp = e.getKey();
            String field = clp.getTerm().field();
            ordinals.length = 0;
            int maxNumOrds = 0;
            for (CategoryPath cp : e.getValue()) {
                int ordinal = this.taxonomyWriter.addCategory(cp);
                if (ordinals.ints.length < (maxNumOrds += cp.length)) {
                    ordinals.grow(maxNumOrds);
                }
                ordinals.ints[ordinals.length++] = ordinal;
            }
            Map<String, BytesRef> categoriesData = this.getCategoryListData(clp, ordinals, e.getValue());
            CountingListStream ts = new CountingListStream();
            ts.setCategoriesData(categoriesData);
            doc.add((IndexableField)new Field(field, (TokenStream)ts, COUNTING_LIST_PAYLOAD_TYPE));
            DrillDownStream drillDownStream = this.getDrillDownStream(e.getValue());
            Field drillDown = new Field(field, (TokenStream)drillDownStream, this.fieldType());
            doc.add((IndexableField)drillDown);
        }
    }

    static {
        COUNTING_LIST_PAYLOAD_TYPE.setIndexed(true);
        COUNTING_LIST_PAYLOAD_TYPE.setTokenized(true);
        COUNTING_LIST_PAYLOAD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        COUNTING_LIST_PAYLOAD_TYPE.setStored(false);
        COUNTING_LIST_PAYLOAD_TYPE.setOmitNorms(true);
        COUNTING_LIST_PAYLOAD_TYPE.freeze();
        DRILL_DOWN_TYPE = new FieldType(TextField.TYPE_NOT_STORED);
        DRILL_DOWN_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        DRILL_DOWN_TYPE.freeze();
    }

    private static final class CountingListStream
    extends TokenStream {
        private final PayloadAttribute payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private Iterator<Map.Entry<String, BytesRef>> categoriesData;

        CountingListStream() {
        }

        public boolean incrementToken() throws IOException {
            if (!this.categoriesData.hasNext()) {
                return false;
            }
            Map.Entry<String, BytesRef> entry = this.categoriesData.next();
            this.termAtt.setEmpty().append(entry.getKey());
            this.payloadAtt.setPayload(entry.getValue());
            return true;
        }

        void setCategoriesData(Map<String, BytesRef> categoriesData) {
            this.categoriesData = categoriesData.entrySet().iterator();
        }
    }
}

